% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRtitle.R
\name{utilMWRtitle}
\alias{utilMWRtitle}
\title{Format the title for analyze functions}
\usage{
utilMWRtitle(
  param,
  site = NULL,
  dtrng = NULL,
  resultatt = NULL,
  locgroup = NULL
)
}
\arguments{
\item{param}{character string of the parameter to plot}

\item{site}{character string of sites to include}

\item{dtrng}{character string of length two for the date ranges as YYYY-MM-DD}

\item{resultatt}{character string of result attributes to plot}

\item{locgroup}{character string of location groups to plot from the \code{"Location Group"} column in the site metadata file}
}
\value{
A formatted character used for the title in analysis plots
}
\description{
Format the title for analyze functions
}
\details{
All arguments are optional except \code{param}, appropriate text strings are appended to the \code{param} argument for all other optional arguments indicating the level of filtering used in the plot
}
\examples{
# no filters
utilMWRtitle(param = 'DO')

# filter by date only
utilMWRtitle(param = 'DO', dtrng = c('2021-05-01', '2021-07-31'))

# filter by all
utilMWRtitle(param = 'DO', site = 'test', dtrng = c('2021-05-01', '2021-07-31'), 
     resultatt = 'test', locgroup = 'test')
}
