% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formMWRfrecom.R
\name{formMWRfrecom}
\alias{formMWRfrecom}
\title{Format data quality objective frequency and completeness data}
\usage{
formMWRfrecom(frecomdat)
}
\arguments{
\item{frecomdat}{input data frame}
}
\value{
A formatted data frame of the data quality objectives file for frequency and completeness
}
\description{
Format data quality objective frequency and completeness data
}
\details{
This function is used internally within \code{\link{readMWRfrecom}} to format the input data for downstream analysis.  The formatting includes:

\itemize{
\item{Convert Parameter: }{All parameters are converted to \code{Simple Parameter} in \code{\link{paramsMWR}} as needed}
}
}
\examples{
library(dplyr)

frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', 
     package = 'MassWateR')

frecomdat <- suppressMessages(readxl::read_excel(frecompth, 
      skip = 1, na = c('NA', 'na', ''), 
      col_types = c('text', 'numeric', 'numeric', 'numeric', 'numeric', 'numeric', 'numeric')
    )) \%>\% 
    rename(`\% Completeness` = `...7`)
    
formMWRfrecom(frecomdat)
}
