/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.pptx4r.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.lysis.reporters.pptx4r.elements.template.LayoutDescription;
import org.lysis.reporters.tools.Debug;


public class DocExplorer {
	
	public static HashMap<String, LayoutDescription> browseLayouts(PresentationMLPackage basedoc) throws InvalidFormatException {
		
		if( Debug.doc_explorer ) System.err.println("# browseLayouts");

		HashMap<String, LayoutDescription> layoutDescriptionList = new HashMap<String, LayoutDescription>();
		
		Iterator<Entry<PartName, Part>> partIterator = basedoc.getParts().getParts().entrySet().iterator();
		
		while (partIterator.hasNext()) {
			Entry<PartName, Part> en =partIterator.next(); 

			if( en.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml")){
				SlideLayoutPart layoutPart = (SlideLayoutPart)basedoc.getParts().getParts().get(new PartName(en.getKey().getName()));

				String lpName = layoutPart.getJaxbElement().getCSld().getName();
				String lpKey = en.getKey().getName();
				if( Debug.doc_explorer ) System.err.println("\n\n## layout part name: " + lpName);
				if( Debug.doc_explorer ) System.err.println("## layout part key: " + lpKey);

				List<Object> slidesSet = layoutPart.getJaxbElement().getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame();
				LayoutDescription lp = new LayoutDescription(slidesSet);
				lp.setLabel(lpName);
				lp.setXMLFilename(lpKey);
				layoutDescriptionList.put(lpName, lp);
			} 
	    }
		return layoutDescriptionList;
	}
	
	public static int countExistingSlides(PresentationMLPackage basedoc){
		int id_slide = 0;
		
		Iterator<Entry<PartName, Part>> partIterator = basedoc.getParts().getParts().entrySet().iterator();
		
		while (partIterator.hasNext()) {
			Entry<PartName, Part> en =partIterator.next(); 

			if( en.getValue().getContentType().equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")){
				id_slide++;
			}
	    }
		return id_slide;
	}

	
}
