% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_multiple_fun.R
\name{fix_vars_amf}
\alias{fix_vars_amf}
\title{Fix \code{vars} parameter to \code{aggregate_multiple_fun}}
\usage{
fix_vars_amf(
  vars,
  name_sep = "_",
  seve_sep = ":",
  multi_sep = ",",
  names_data = NULL,
  ...
)
}
\arguments{
\item{vars}{vars}

\item{name_sep}{A character string used when output variable names are generated.}

\item{seve_sep}{A character string used when output variable names are generated from functions of several variables.}

\item{multi_sep}{A character string used when multiple output variable names are sent as input.}

\item{names_data}{\code{names(data)} to convert numeric input (indices)}

\item{...}{unused parameters}
}
\value{
vars
}
\description{
Fix \code{vars} parameter to \code{aggregate_multiple_fun}
}
\examples{
f <- fix_vars_amf

f(c("freq", "y", median = "freq", median = "y", e1 = "freq"))

v1 <- list(sum = "a", sum = "w", q = c("a", "w"), mean = c("b", "w"))
v2 <- list(c(fun = "sum", "a"), c(fun = "sum", "w"), c(fun = "q", "a", "w"), 
           c(fun = "mean", "b", "w"))
v3 <- list(sum = "a", sum = "w", q = c(name = "a:w_q", "a", "w"), 
           `b:w_mean` = list(mean = c("b", "w")))
v4 <- list(c(name = "a_sum", fun = "sum", "a"), 
           c(name = "w_sum", fun = "sum", "w"), 
           c(name = "a:w_q", fun = "q", "a", "w"), 
           c(name = "b:w_mean", fun = "mean", "b", "w"))
v5 <- list(a_sum = c(fun = "sum", "a"), 
           w_sum = c(fun = "sum", "w"), 
           `a:w_q` = c(fun = "q", "a", "w"), 
           `b:w_mean` = c(fun = "mean", "b", "w"))

identical(f(v1), f(v2))
identical(f(v1), f(v3))
identical(f(v1), f(v4))
identical(f(v1), f(v5))

identical(f(v1), f(f(v1)))
identical(f(v1), v4)
}
\keyword{internal}
