% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TeachHistHypTest.R
\name{TeachHistHypTest}
\alias{TeachHistHypTest}
\title{Histogram to Visualize Hypothesis Tests}
\usage{
TeachHistHypTest(
  NullHyp,
  StandardError,
  SampleMean,
  DegreeFreedom = NULL,
  Confidence = 0.95,
  TestType = "BothTails",
  IsSdEstimated = FALSE,
  NOfSimData = 10000,
  XAxisMax = 5,
  LabelSize = 3,
  BinWidth = 0.5,
  PrintDensities = FALSE,
  PrintRelFreq = TRUE,
  PlotNormCurv = TRUE,
  RandVarName = "Means",
  SeedValue = NULL
)
}
\arguments{
\item{NullHyp}{required! Value for null hypotheses.}

\item{StandardError}{required!}

\item{SampleMean}{required! SampleMean is the mean from the research sample to support the alternative/research hypotheses.}

\item{DegreeFreedom}{required for t-test (IsSdEstimated=TRUE)}

\item{Confidence}{(default=0.950 Confidence level.}

\item{TestType}{(default="BothTails") User can also choose TestType="LeftTail" or TestType="RightTail"}

\item{IsSdEstimated}{(default=FALSE) standard deviation or standard error are known. Set to FALSE, if estimated.}

\item{NOfSimData}{(default=10000) Number of simulated data points. Higher NOfSimData results in better precision but possibly not all points are considered.}

\item{XAxisMax}{(default=5) X-axis ranges from negative to positive XAxisMax. If XAxisMax is not high enough, some of the simulated points might not be considered.}

\item{LabelSize}{(default=3) Size of the labels inside the diagram.}

\item{BinWidth}{(default= 0.5) BinWidth expressed in standard deviations.}

\item{PrintDensities}{(default=FALSE) Set PrintDensities=TRUE to print densities in the histogram.}

\item{PrintRelFreq}{(default=TRUE) Set PrintRelFreq=FALSE to supress the printing of relative frequencies in the histogram.}

\item{PlotNormCurv}{(default=TRUE) If TRUE normal curve is plotted}

\item{RandVarName}{(default="Means") Variable name that is plotted in histogram at x-axis.}

\item{SeedValue}{(default=NULL) Can be any integer and makes simulated points reproduceable.}
}
\value{
Returns a histogram
}
\description{
The TeachHistHypTest function is a variation of the TeachHistDens function of this package. It generates a histogram with two horizontal axis. One axis displays z-values the other one the
dimension of the displayed variable and it is optimized to visualize hypothesis testing.
}
\details{
The TeachHistHypTest function upports t-test (IsSdEstimated=TRUE) and z-test (IsSdEstimated=FALSE). It also supports
TestType="BothTails", TestType="LeftTail", and TestType="RightTail".
}
\examples{
TeachHistHypTest(70,2,77)
TeachHistHypTest(70,2,77, DegreeFreedom = 35,  IsSdEstimated = TRUE)
TeachHistHypTest(70,2,65, DegreeFreedom = 35,  IsSdEstimated = TRUE, TestType = "LeftTail")
}
