% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELEFAN_SA.R
\name{ELEFAN_SA}
\alias{ELEFAN_SA}
\title{ELEFAN_SA}
\usage{
ELEFAN_SA(
  lfq,
  seasonalised = FALSE,
  init_par = list(Linf = 50, K = 0.5, t_anchor = 0.5, C = 0, ts = 0),
  low_par = NULL,
  up_par = NULL,
  SA_time = 60 * 1,
  maxit = NULL,
  nb.stop.improvement = NULL,
  SA_temp = 1e+05,
  verbose = TRUE,
  MA = 5,
  addl.sqrt = FALSE,
  agemax = NULL,
  flagging.out = TRUE,
  plot = FALSE,
  plot.score = TRUE
)
}
\arguments{
\item{lfq}{a list consisting of following parameters:
\itemize{
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{catch} matrix with catches/counts per length class (row)
     and sampling date (column);
}}

\item{seasonalised}{logical; indicating if the seasonalised von Bertalanffy
growth function should be applied (default: FALSE).}

\item{init_par}{a list providing the Initial values for the components to be
optimized. When set to NULL the following default values are used:
 \itemize{
  \item \strong{Linf} length infinity in cm (default is the maximum
  length class in the data),
  \item \strong{K} curving coefficient (default: 0.5),
  \item \strong{t_anchor} time point anchoring growth curves in year-length
  coordinate system, corrsponds to peak spawning month (range: 0 to 1, default: 0.5),
  \item \strong{C} amplitude of growth oscillation (range: 0 to 1, default: 0),
  \item \strong{ts} summer point (ts = WP - 0.5) (range: 0 to 1, default: 0);
}}

\item{low_par}{a list providing the lower bounds for components. When set to
NULL the following default values are used:
 \itemize{
  \item \strong{Linf} length infinity in cm (default is calculated from maximum
  length class in the data),
  \item \strong{K} curving coefficient (default: 0.01),
  \item \strong{t_anchor} time point anchoring growth curves in year-length
  coordinate system, corrsponds to peak spawning month (range: 0 to 1, default: 0),
  \item \strong{C} amplitude of growth oscillation (range: 0 to 1, default: 0),
  \item \strong{ts} summer point (ts = WP - 0.5) (range: 0 to 1, default: 0);
}}

\item{up_par}{a list providing the upper bounds for components. When set to
NULL the following default values are used:
 \itemize{
  \item \strong{Linf} length infinity in cm (default is calculated from maximum
  length class in the data),
  \item \strong{K} curving coefficient (default: 0.01),
  \item \strong{t_anchor} time point anchoring growth curves in year-length
  coordinate system, corrsponds to peak spawning month (range: 0 to 1, default: 0),
  \item \strong{C} amplitude of growth oscillation (range: 0 to 1, default: 0),
  \item \strong{ts} summer point (ts = WP - 0.5) (range: 0 to 1, default: 0);
}}

\item{SA_time}{numeric; Maximum running time in seconds (default : 60 * 1).}

\item{maxit}{Integer. Maximum number of iterations of the
algorithm. Default is NULL.}

\item{nb.stop.improvement}{Integer. The program will stop when
there is no any improvement in 'nb.stop.improvement'
steps. Default is NULL}

\item{SA_temp}{numeric; Initial value for temperature (default : 1e5).}

\item{verbose}{logical; TRUE means that messages from the algorithm
are shown (default : TRUE).}

\item{MA}{number indicating over how many length classes the moving average
should be performed (defalut: 5, for
  more information see \link{lfqRestructure}).}

\item{addl.sqrt}{Passed to \link{lfqRestructure}. Applied an additional
square-root transformation of positive values according to Brey et al. (1988).
(default: FALSE, for more information see \link{lfqRestructure}).}

\item{agemax}{maximum age of species; default NULL, then estimated from Linf}

\item{flagging.out}{logical; passed to \link{lfqFitCurves}. Default is TRUE}

\item{plot}{logical; Plot restructured counts with fitted lines using
\code{\link{plot.lfq}} and \code{\link{lfqFitCurves}} (default : FALSE).}

\item{plot.score}{logical; Plot simulated annealing score progression.
(Default: plot.score=TRUE)}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{rcounts}: restructured frequencies,
  \item \strong{peaks_mat}: matrix with positive peaks with distinct values,
  \item \strong{ASP}: available sum of peaks, sum of posititve peaks which
     could be potential be hit by
     growth curves,
  \item \strong{ncohort}: maximum age of species,
  \item \strong{agemax}: maximum age of species,
  \item \strong{par}: a list with the parameters of the von Bertalanffy growth
     function:
     \itemize{
       \item \strong{Linf}: length infinity in cm,
       \item \strong{K}: curving coefficient;
       \item \strong{t_anchor}: time point anchoring growth curves in year-length
         coordinate system, corrsponds to peak spawning month,
       \item \strong{C}: amplitude of growth oscillation
         (if \code{seasonalised} = TRUE),
       \item \strong{ts}: summer point of oscillation (ts = WP - 0.5)
         (if \code{seasonalised} = TRUE),
       \item \strong{phiL}: growth performance index defined as
         phiL = log10(K) + 2 * log10(Linf);
     }
  \item \strong{Rn_max}:  highest score value (absolute value of cost function,
  comparable with ELEFAN and ELEFAN_GA).
}
}
\description{
Electronic LEngth Frequency ANalysis with simulated annealing
   for estimating growth parameters.
}
\details{
A more detailed description of the simulated annealing (SA) can be found in
   Xiang et al. (2013). The score value \code{cost_value} is not comparable with
   the score value of the other ELEFAN functions (\code{\link{ELEFAN}} or
   \code{\link{ELEFAN_GA}}).
}
\examples{
\donttest{
## synthetic lfq data example
data(synLFQ4)
plot(synLFQ4, Fname="catch")

# ELEFAN_SA (takes approximately 2 minutes)
output <- ELEFAN_SA(synLFQ4, SA_time = 60*2, seasonalised = TRUE, MA = 11,
  init_par = list(Linf = 75, K = 0.5, t_anchor = 0.5, C = 0.5, ts = 0.5),
  low_par = list(Linf = 70, K = 0.3, t_anchor = 0, C = 0, ts = 0),
  up_par = list(Linf = 90, K = 0.7, t_anchor = 1, C = 1, ts = 1))
output$par
output$Rn_max

# view fit
plot(output)

# or
plot(output, draw = FALSE)
lfqFitCurves(output, col=1, par=output$par, draw=TRUE)$ESP

# compare to original parameters
tmp <- lfqFitCurves(output, col=4, lty=1,
   par=list(Linf=80, K=0.5, t_anchor=0.25, C=0.75, ts=0.5), draw=TRUE)
tmp$fESP
output$Rn_max
}

}
\references{
Brey, T., Soriano, M., and Pauly, D. 1988. Electronic length frequency analysis: a revised and
expanded
user's guide to ELEFAN 0, 1 and 2.

Pauly, D. and N. David, 1981. ELEFAN I, a BASIC program for the objective extraction of
growth parameters from length-frequency data. \emph{Meeresforschung}, 28(4):205-211

Xiang, Y., Gubian, S., Suomela, B., & Hoeng, J. (2013). Generalized simulated
annealing for global optimization: the GenSA Package. R Journal, 5(1), 13-28.
}
