% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check.R
\name{errorMessage}
\alias{errorMessage}
\title{Convert Objects to Detailed Error Message.}
\usage{
errorMessage(...)
}
\arguments{
\item{...}{one or multiple objects separated by comma}
}
\value{
(characer) string combining information from input-objects
}
\description{
Function takes one or multiple objects and converts them to a single
error-message. Objects can be output of functions \code{\link{try}} or
\code{\link{checkData}}.
}
\examples{
\dontrun{
data(dataEP05A2_1)
dat2 <- dataEP05A2_1[1:16,]
dat2$y <- dat2$y[rep(seq(1,7,2), rep(2,4))] 
errorMessage(try(1/"a"), checkData(y~day/run, dat2))
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
