% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check.R
\name{protectedCall}
\alias{protectedCall}
\title{Wrap Function-Calls to Execute Additional Checks.}
\usage{
protectedCall(expr, ErrorType = c("Simple", "Detailed"))
}
\arguments{
\item{expr}{(expression) to be protected, typically, a call to a model-fitting 
function from this package (see details)}

\item{ErrorType}{(ErrorType) "Simple"=default error-messages, "Detailed"= additional
data consistency checks will be performed}
}
\description{
Function can be used to wrap function-calls, here, intended for model fitting
functions \code{\link{anovaVCA}}, \code{\link{anovaMM}}, \code{\link{remlVCA}}, \code{\link{remlMM}},
\code{\link{fitVCA}}, and \code{\link{fitLMM}}. When wrapped, there is the option to 
perform additional checks and reporting back identified problems by setting 'ErrorType="Detailed"'.
There is no error-handling provided by this function, i.e. any error issued will remain an error.
It would need to be handled by \code{\link{try}}, \code{\link{tryCatch}} or similar.
Note, that inline definition of datasets within 'expr' is not supported and will issue an error.
}
\examples{
\dontrun{
# nothing happens if no error occurs
data(dataEP05A2_1)
res <- protectedCall(anovaVCA(form=y~day/run, Data=dataEP05A2_1))
res
# error message without additional consistency checks (default)
dat3 <- data.frame(	y=rnorm(8,10),
						day=rep(c(1,2),c(4,4)), 
						run=rep(c(2,1), c(4,4)))
protectedCall(anovaVCA(form=y~day/run, Data=dat3), ErrorType="Simple")
# error message with additional consistency checks hopefully helpful for the user
protectedCall(anovaVCA(form=y~day/run, Data=dat3), ErrorType="Detailed")

# handle error
res <- try(protectedCall(anovaVCA(form=y~day/run, Data=dat3), ErrorType="Detailed"), silent=TRUE)
if(is(res, "try-error"))
	cat(sub(", ErrorType .*\\\\)", "", sub("protectedCall\\\\(", "", res)))

# inline-definition of data.frames issues an error
protectedCall(anovaVCA(	form=y~day/run, 
							Data=data.frame(y=rnorm(8,10),
								day=rep(c(1,2),c(4,4)), 
								run=rep(c(2,1), c(4,4)))))
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
