% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bauge.R
\name{bauge}
\alias{bauge}
\title{Simple Gauge}
\usage{
bauge(value, min = 0, max = 100, colors = NULL, steps = NULL,
  label_tooltip = NULL, label_show = TRUE, label_format = NULL,
  label_extents = NULL, expand = TRUE, subtitle = NULL,
  full_circle = FALSE, gauge_width = NULL, width = NULL,
  height = NULL, elementId = NULL)
}
\arguments{
\item{value}{Value for the gauge.}

\item{min}{Minimal value for the gauge, default to \code{0}.}

\item{max}{Maximal value for the gauge, default to \code{100}.}

\item{colors}{Vector of color(s), if more than one, \code{steps} must be specified.}

\item{steps}{Upper bound for changing colors.}

\item{label_tooltip}{Label to appear on the tooltip, when mouse is hovering the gauge.}

\item{label_show}{Show or not minimal and maximal labels.}

\item{label_format}{JavaScript function to format inner label.}

\item{label_extents}{JavaScript function to set custom labels.}

\item{expand}{Enable or disable expanding gauge.}

\item{subtitle}{Additional text to add below the value.}

\item{full_circle}{Show full circle as donut. When set to \code{TRUE},
the max label will not be showed due to start and end points are same location.}

\item{gauge_width}{Set width of gauge chart.}

\item{width}{Width of the element container.}

\item{height}{Height of the element container.}

\item{elementId}{Use an explicit element ID for the widget.}
}
\description{
A gauge that automatically updates itself in Shiny apps.
}
\examples{

bauge(45)

bauge(67, colors = "#F6C600")

bauge(90, full_circle = TRUE)

bauge(90, max = 210, gauge_width = 20, label_format = suffix(" km/h"))

# Shiny example
if (interactive()) {
  library(shiny)
  
  ui <- fluidPage(
    baugeOutput(outputId = "gauge", width = "300px"),
    actionButton(inputId = "update_value", label = "Update value"),
    actionButton(inputId = "update_max", label = "Update max")
  )
  
  server <- function(input, output, session) {
    
    value <- reactive({
      input$update_value
      round(sample.int(100, 1))
    })
    
    max_value <- reactive({
      input$update_max
      sample(100:200, 1)
    })
    
    output$gauge <- renderBauge({
      bauge(
        value = value(),
        max = max_value(),
        steps = c(30, 60, 90, 100),
        colors = c("#FF0000", "#F97600", "#F6C600", "#60B044")
      )
    })
    
  }
  
  shinyApp(ui, server)
}
}
