% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_legend}
\alias{bb_legend}
\title{Add legend parameters}
\usage{
bb_legend(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.legend}.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Add legend parameters
}
\examples{
library("billboarder")

stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer", "shinyWidgets", "visNetwork"),
  stars = c(1, 176, 42, 40, 166)
)

# Hide legend
billboarder() \%>\%
  bb_barchart(data = stars) \%>\% 
  bb_legend(show = FALSE)

# Right legend
billboarder() \%>\%
  bb_piechart(data = stars) \%>\% 
  bb_legend(position = "right")

# Inset legend
billboarder() \%>\%
  bb_scatterplot(data = iris, x = "Sepal.Length", y = "Sepal.Width", group = "Species") \%>\% 
  bb_axis(x = list(tick = list(fit = FALSE))) \%>\% 
  bb_legend(position = "inset", inset = list(anchor = "top-right"))

}
