% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_plot.R
\name{mlm_pars_plot}
\alias{mlm_pars_plot}
\title{Plot estimated parameters of multilevel mediation model}
\usage{
mlm_pars_plot(
  mod = NULL,
  type = "hist",
  color = "black",
  p_shape = 15,
  p_size = 1.2,
  level = 0.95,
  nrow = 3,
  pars = c("a", "b", "cp", "covab", "me", "c", "pme")
)
}
\arguments{
\item{mod}{A Stanfit model estimated with \code{mlm()}.}

\item{type}{Type of the plot, \code{hist}, \code{coef}, or \code{violin}.}

\item{color}{Color (and fill) for plots.}

\item{p_shape}{Shape of points for coefplot.}

\item{p_size}{Size of points for coefplot.}

\item{level}{X level for Credible Intervals. (Defaults to .95.)}

\item{nrow}{Number of rows for multiple histograms.}

\item{pars}{Which parameters to plot.}
}
\value{
A ggplot2 object.
}
\description{
Plot the model's estimated parameters as histograms or a coefficient plot.
}
\details{
The point estimate for the coefficient plot is the posterior mean.
}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}
