% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psd_check.R
\name{psd_check}
\alias{psd_check}
\alias{psd_check.GBN}
\alias{psd_check.CI}
\title{Check for positive semi-definiteness after a perturbation}
\usage{
psd_check(x, ...)

\method{psd_check}{GBN}(x, entry, delta, ...)

\method{psd_check}{CI}(x, type, entry, delta, ...)
}
\arguments{
\item{x}{object of class \code{GBN} or \code{CI}.}

\item{...}{additional arguments for compatibility.}

\item{entry}{a vector of length 2 indicating the entry of the covariance matrix to vary.}

\item{delta}{numeric vector, including the variation parameters that act additively.}

\item{type}{character string. Type of model-preserving co-variation: either \code{total}, \code{partial}, \code{row}, \code{column} or \code{all}. If \code{all}, the Frobenius norms are computed for every type of co-variation matrix.}
}
\value{
A dataframe including the variations performed and the check for positive semi-definiteness.
}
\description{
\code{psd_check} returns a boolean to determine if the covariance matrix after a perturbation is positive semi-definite.
}
\details{
The details depend on the class the method \code{psd_check} is applied to.

Let \eqn{\Sigma} be the covariance matrix of a Gaussian Bayesian network and let \eqn{D} be a perturbation matrix acting additively. The perturbed covariance matrix \eqn{\Sigma+D} is positive semi-definite if
\deqn{\rho(D)\leq \lambda_{\min}(\Sigma)}
where \eqn{\lambda_{\min}} is the smallest eigenvalue end \eqn{\rho} is the spectral radius.
}
\section{Methods (by class)}{
\itemize{
\item \code{GBN}: \code{psd_check} for objects \code{GBN}

\item \code{CI}: \code{psd_check} for objects \code{CI}
}}

\examples{
psd_check(synthetic_gbn,c(2,4),-3)
psd_check(synthetic_gbn,c(2,3),seq(-1,1,0.1))
psd_check(synthetic_ci,"partial",c(2,4),0.95)
psd_check(synthetic_ci,"all",c(2,3),seq(0.9,1.1,0.01))

}
\references{
C. Görgen & M. Leonelli (2020), Model-preserving sensitivity analysis for families of Gaussian distributions.  Journal of Machine Learning Research, 21: 1-32.
}
