% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_smooths.R
\name{conditional_smooths.brmsfit}
\alias{conditional_smooths.brmsfit}
\alias{marginal_smooths}
\alias{marginal_smooths.brmsfit}
\alias{conditional_smooths}
\title{Display Smooth Terms}
\usage{
\method{conditional_smooths}{brmsfit}(
  x,
  smooths = NULL,
  int_conditions = NULL,
  probs = c(0.025, 0.975),
  spaghetti = FALSE,
  resolution = 100,
  too_far = 0,
  subset = NULL,
  nsamples = NULL,
  ...
)

conditional_smooths(x, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{smooths}{Optional character vector of smooth terms
to display. If \code{NULL} (the default) all smooth terms
are shown.}

\item{int_conditions}{An optional named \code{list} whose elements are
vectors of values of the variables specified in \code{effects}. 
At these values, predictions are evaluated. The names of 
\code{int_conditions} have to match the variable names exactly.
Additionally, the elements of the vectors may be named themselves,
in which case their names appear as labels for the conditions in the plots.
Instead of vectors, functions returning vectors may be passed and are
applied on the original values of the corresponding variable.
If \code{NULL} (the default), predictions are evaluated at the 
\eqn{mean} and at \eqn{mean +/- sd} for numeric predictors and at
all categories for factor-like predictors.}

\item{probs}{The quantiles to be used in the computation of credible
intervals (defaults to 2.5 and 97.5 percent quantiles)}

\item{spaghetti}{Logical. Indicates if predictions should
be visualized via spaghetti plots. Only applied for numeric
predictors. If \code{TRUE}, it is recommended 
to set argument \code{nsamples} to a relatively small value 
(e.g. \code{100}) in order to reduce computation time.}

\item{resolution}{Number of support points used to generate 
the plots. Higher resolution leads to smoother plots. 
Defaults to \code{100}. If \code{surface} is \code{TRUE},
this implies \code{10000} support points for interaction terms,
so it might be necessary to reduce \code{resolution} 
when only few RAM is available.}

\item{too_far}{Positive number. 
For surface plots only: Grid points that are too 
far away from the actual data points can be excluded from the plot. 
\code{too_far} determines what is too far. The grid is scaled into 
the unit square and then grid points more than \code{too_far} 
from the predictor variables are excluded. By default, all
grid points are used. Ignored for non-surface plots.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{...}{Currently ignored.}
}
\value{
For the \code{brmsfit} method, 
an object of class \code{brms_conditional_effects}. See
\code{\link{conditional_effects}} for 
more details and documentation of the related plotting function.
}
\description{
Display smooth \code{s} and \code{t2} terms of models
fitted with \pkg{brms}.
}
\details{
Two-dimensional smooth terms will be visualized using
  either contour or raster plots.
}
\examples{
\dontrun{
set.seed(0) 
dat <- mgcv::gamSim(1, n = 200, scale = 2)
fit <- brm(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
# show all smooth terms
plot(conditional_smooths(fit), rug = TRUE, ask = FALSE)
# show only the smooth term s(x2)
plot(conditional_smooths(fit, smooths = "s(x2)"), ask = FALSE)

# fit and plot a two-dimensional smooth term
fit2 <- brm(y ~ t2(x0, x2), data = dat)
ms <- conditional_smooths(fit2)
plot(ms, stype = "contour")
plot(ms, stype = "raster")
}

}
