% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card}
\alias{card}
\title{A Bootstrap card component}
\usage{
card(
  ...,
  full_screen = FALSE,
  height = NULL,
  max_height = NULL,
  min_height = NULL,
  fill = TRUE,
  class = NULL,
  wrapper = card_body
)
}
\arguments{
\item{...}{Unnamed arguments can be any valid child of an \link[htmltools:builder]{htmltools tag} (which includes card items such as \code{\link[=card_body]{card_body()}}.
Named arguments become HTML attributes on returned UI element.}

\item{full_screen}{If \code{TRUE}, an icon will appear when hovering over the card
body. Clicking the icon expands the card to fit viewport size.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{max_height, min_height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{max_height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{max_height} in \code{\link[=card_body]{card_body()}}).}

\item{fill}{Whether or not to allow the card to grow/shrink to fit a
fillable container with an opinionated height (e.g., \code{page_fillable()}).}

\item{class}{Additional CSS classes for the returned UI element.}

\item{wrapper}{A function (which returns a UI element) to call on unnamed
arguments in \code{...} which are not already card item(s) (like
\code{\link[=card_header]{card_header()}}, \code{\link[=card_body]{card_body()}}, etc.). Note that non-card items are grouped
together into one \code{wrapper} call (e.g. given \code{card("a", "b", card_body("c"), "d")}, \code{wrapper} would be called twice, once with \code{"a"} and
\code{"b"} and once with \code{"d"}).}
}
\value{
A \code{\link[htmltools:builder]{htmltools::div()}} tag.
}
\description{
A general purpose container for grouping related UI elements together with a
border and optional padding. To learn more about \code{\link[=card]{card()}}s, see \href{https://rstudio.github.io/bslib/articles/cards.html}{this article}.
}
\examples{

library(htmltools)

if (interactive()) {
  card(
    full_screen = TRUE,
    card_header(
      "This is the header"
    ),
    card_body(
      p("This is the body."),
      p("This is still the body.")
    ),
    card_footer(
      "This is the footer"
    )
  )
}

}
\seealso{
\code{\link[=card_body]{card_body()}} for putting stuff inside the card.

\code{\link[=navset_card_tab]{navset_card_tab()}} for cards with multiple tabs.

\code{\link[=layout_column_wrap]{layout_column_wrap()}} for laying out multiple cards (or multiple
columns inside a card).
}
