% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValeMorelli.r
\name{rValeMaurelli}
\alias{rValeMaurelli}
\title{\code{rValeMaurelli} Simulate data from a multivariate nonnormal distribution such that
1) Each marginal distribution has a specified skewness and kurtosis
2) The marginal variables have the correlation matrix R}
\usage{
rValeMaurelli(n, R, Fcoef)
}
\arguments{
\item{n}{number of random vectors to be generated}

\item{R}{desired correlation matrix of transformed variables}

\item{Fcoef}{either vector with coefficents for the Fleishman transform to be applied to all variables or
(nrow(R),3) matrix with different coefficients}
}
\value{
X  (n,nrow(R)) data matrix
}
\description{
\code{rValeMaurelli} Simulate data from a multivariate nonnormal distribution such that
1) Each marginal distribution has a specified skewness and kurtosis
2) The marginal variables have the correlation matrix R
}
\examples{
R <- matrix(c(1, 0.5, 0.3, 0.5 ,1, 0.2 , 0.3, 0.2 , 1),3,3)
coef <-  matrix(c( 0.90475830, 0.14721082, 0.02386092,0.78999781,0.57487681,
                            -0.05473674,0.79338100, 0.05859729, 0.06363759 ),3,3,byrow=TRUE) 
V <- rValeMaurelli(50, R, coef) 

}
