% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-values.R
\name{check_annotation_values}
\alias{check_annotation_values}
\alias{check_annotation_values.NULL}
\alias{check_annotation_values.synapseclient.entity.File}
\alias{check_annotation_values.data.frame}
\alias{check_annotation_values.synapseclient.table.CsvFileTable}
\title{Check annotation values}
\usage{
check_annotation_values(x, annotations, ...)

\method{check_annotation_values}{`NULL`}(x, annotations, ...)

\method{check_annotation_values}{synapseclient.entity.File}(x, annotations, syn, ...)

\method{check_annotation_values}{data.frame}(x, annotations, ...)

\method{check_annotation_values}{synapseclient.table.CsvFileTable}(x, annotations, ...)
}
\arguments{
\item{x}{An object to check.}

\item{annotations}{A data frame of annotation definitions. Must contain at
least three columns: \code{key}, \code{value}, and \code{columnType}.}

\item{...}{Additional options to \code{\link[=check_values]{check_values()}}}

\item{syn}{Synapse client object}
}
\value{
A condition object indicating whether all annotation values are
valid. Invalid annotation values are included as data within the object.
}
\description{
Checks that all annotation values are valid. It does not report on values for
invalid \emph{keys}; see \code{\link[=check_annotation_keys]{check_annotation_keys()}}.
}
\details{
If the allowable annotation values are an enumerated list,
\code{check_annotation_values()} compares the values in the data to the values in
this list. If there is no enumerated list of values and the annotation
definition merely specifies a required type, then the values are checked
against that type, with values that are coercible to the correct type treated
as valid (see \code{\link[=can_coerce]{can_coerce()}}).
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: Return NULL

\item \code{synapseclient.entity.File}: Check annotation values on a Synapse file

\item \code{data.frame}: Check annotation values in a data frame

\item \code{synapseclient.table.CsvFileTable}: Check annotation values in a Synapse table
}}

\examples{
annots <- data.frame(
  key = c("assay", "fileFormat", "fileFormat", "fileFormat", "species"),
  value = c("rnaSeq", "fastq", "txt", "csv", "Human"),
  columnType = c("STRING", "STRING", "STRING", "STRING", "STRING")
)
dat1 <- data.frame(assay = "not a valid assay")
dat2 <- data.frame(assay = "rnaSeq")
check_annotation_values(dat1, annots)
check_annotation_values(dat2, annots)

\dontrun{
syn <- synapse$Synapse()
syn$login()

annots <- get_synapse_annotations(syn = syn)
my_file <- syn$get("syn11931757", downloadFile = FALSE)
check_annotation_values(my_file, annots)

dat <- data.frame(
  non_annotation = 5:7,
  assay = c("rnaSeq", "foo", "bar"),
  stringsAsFactors = FALSE
)
check_annotation_values(dat, annots)

fv <- synTableQuery("SELECT * FROM syn17020234")
check_annotation_values(fv, annots)

# If you don't specify an annotations data frame, these functions will
# download annotations automatically using `get_synapse_annotations()` (must
# be logged in to Synapse)
my_file <- syn$get("syn11931757", downloadFile = FALSE)
check_annotation_values(my_file, syn = syn)

# It is possible to whitelist certain certain values, or all values for
# certain keys:
check_annotation_values(dat, whitelist_keys = "assay", syn = syn)

check_annotation_values(
  dat,
  whitelist_values = list(assay = c("foo")),
  syn = syn
)
}
}
\seealso{
\code{\link[=valid_annotation_values]{valid_annotation_values()}}, \code{\link[=can_coerce]{can_coerce()}}
}
