% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_expression.R
\name{wrap_expression}
\alias{wrap_expression}
\title{Create a wrapper object with expression and counts}
\usage{
wrap_expression(
  id = NULL,
  expression,
  counts,
  cell_info = NULL,
  feature_info = NULL,
  expression_future = NULL,
  ...
)
}
\arguments{
\item{id}{A unique identifier for the data. If \code{NULL}, a random string will be generated.}

\item{expression}{The normalised expression values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{counts}{The counts values of genes (columns) within cells (rows). This can be both a dense and sparse matrix.}

\item{cell_info}{Optional meta-information pertaining the cells.}

\item{feature_info}{Optional meta-information of the features, a dataframe with at least \emph{feature_id} as column}

\item{expression_future}{Projected expression using RNA velocity of genes (columns) within cells (rows).  This can be both a dense and sparse matrix.}

\item{...}{extra information to be stored in the dataset}
}
\description{
Projected expression based on RNA velocity can also be added to the wrapper through the \code{expression_future} argument
}
\details{
Information about the cells and/or features can be added through \code{cell_info} and \code{feature_info}
}
\examples{
dataset <- wrap_expression(
  counts = example_dataset$counts,
  expression = example_dataset$expression,
  expression_future = example_dataset$expression_future
)

dataset$counts[1:10, 1:3]
dataset$expression[1:10, 1:3]
dataset$expression_future[1:10, 1:3]

}
\keyword{infer_trajectory}
