% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_level.R
\name{assess_completeness}
\alias{assess_completeness}
\title{Assess completeness of a dataset}
\usage{
assess_completeness(data, id_var, plot = TRUE)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{id_var}{An unquoted  expression which corresponds to a variable (column) in
\code{data} which identifies each row (sample).}

\item{plot}{Should plots be rendered when function is run? (Default: TRUE)}
}
\value{
list of completeness tibbles and plots
}
\description{
Assesses and visualises completeness of the input data across both rows (samples)
and columns (variables).
}
\details{
Returns a list of completeness assessments:
\describe{
\item{variable_completeness}{A tibble detailing completeness of variables (columns)
(via \code{\link{variable_completeness}}).}
\item{row_completeness}{A tibble detailing completeness of rows (via
\code{\link{row_completeness}}).}
\item{completeness_plot}{A plot of row and variable (column) completeness (via
\code{\link{plot_completeness}}).}
\item{completeness_heatmap}{A clustered heatmap of cell completeness (via
\code{\link{completeness_heatmap}}).}
\item{plot_completeness_heatmap}{A function which creates a clean canvas before 
plotting the completeness heatmap.}
}
}
\examples{
data(example_data)
res <- assess_completeness(example_data, patient_id)

# variable completeness table
res$variable_completeness

# row completeness table
res$row_completeness

# show completeness of rows and variables as a bar plot
res$completeness_plot

# show dataset completeness in a clustered heatmap
# (this is similar to res$completeness_heatmap but ensures a blank canvas is first created)
res$plot_completeness_heatmap(res)

}
\seealso{
Other measures of completeness: 
\code{\link{compare_completeness}()},
\code{\link{completeness_heatmap}()},
\code{\link{plot_completeness}()},
\code{\link{row_completeness}()},
\code{\link{variable_completeness}()}
}
\concept{measures of completeness}
