% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_completeness.R
\name{compare_completeness}
\alias{compare_completeness}
\title{Compare Completeness between Datasets}
\usage{
compare_completeness(tbl_a, tbl_b, dim = 2, tbl_a_lab = NULL, tbl_b_lab = NULL)
}
\arguments{
\item{tbl_a}{Data frame of the first data frame to compare.}

\item{tbl_b}{Data frame of the second data frame to compare.}

\item{dim}{Integer. Dimension to measure completeness on. 2 (Default)
measures completeness by variable. 1 measures completeness by row.}

\item{tbl_a_lab}{String to be used to label \code{tbl_a} on the output plot.}

\item{tbl_b_lab}{String to be used to label \code{tbl_b} on the output plot.}
}
\value{
Plot showing densities of completeness across both datasets.
}
\description{
Produces a density plot comparing the completeness of two datasets
(\code{tbl_a} and \code{tbl_b}) for variables (if \code{dim} == 2, default)
or row (if \code{dim} == 1). The label used to identify the dataset's density
curve can be specified using \code{tbl_a_lab} and \code{tbl_b_lab}.
}
\examples{
data(example_data)
compare_completeness(example_data, strings_to_NA(example_data), dim = 2,
                     "raw", "cleaned")

}
\seealso{
Other measures of completeness: 
\code{\link{assess_completeness}()},
\code{\link{completeness_heatmap}()},
\code{\link{plot_completeness}()},
\code{\link{row_completeness}()},
\code{\link{variable_completeness}()}
}
\concept{measures of completeness}
