% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_vars.R
\name{merge_cols}
\alias{merge_cols}
\title{Merge columns in data frame}
\usage{
merge_cols(
  data,
  primary_var,
  secondary_var,
  merge_var_name = NULL,
  rm_in_vars = FALSE
)
}
\arguments{
\item{data}{data frame containing \code{primary_var} and
\code{secondary_var}.}

\item{primary_var}{Data variable
which contains the best quality / most detailed information. Missing values
will be supplied by values in corresponding rows from \code{secondary_var}.}

\item{secondary_var}{Data variable
which will be used to fill missing values in \code{primary_var}.}

\item{merge_var_name}{character constant. Name for merged variable. Default:
[\code{primary_var}]_[\code{secondary_var}]_merged}

\item{rm_in_vars}{logical constant. Should \code{primary_var} and
\code{secondary_var} be removed? Default = FALSE.}
}
\value{
data frame with coalesced \code{primary_var} and \code{secondary_var}
}
\description{
Merges two columns in a single data frame. The merging draws on the
functionality of \code{'dplyr'}'s \code{\link[dplyr]{coalesce}} where missing
values from one vector are replaced by corresponding values in a second
variable. The name of the merged variable is specified in
\code{merge_var_name}. \code{primary_var} and \code{secondary_var} can be
removed with \code{rm_in_vars}. Variables must be combinable (i.e. not a
combination of numeric and character).
}
\examples{
data(example_data)

# preserve input variables (default)
res <- merge_cols(example_data, diabetes_type, diabetes)
dplyr::select(res, dplyr::starts_with("diabetes"))

# remove input variables
res <- merge_cols(example_data, diabetes_type, diabetes, rm_in_vars = TRUE)
dplyr::select(res, dplyr::starts_with("diabetes"))

}
\seealso{
\code{\link[dplyr]{coalesce}}
}
