% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{supports_sampling}
\alias{supports_sampling}
\title{Does this selector support sampling of outcomes?}
\usage{
supports_sampling(x, ...)
}
\arguments{
\item{x}{Object of type \code{\link{selector}}}

\item{...}{arguments passed to other methods}
}
\value{
logical
}
\description{
Learn whether this selector supports sampling of outcomes. For instance, is
it possible to get posterior samples of the probability of toxicity at each
dose? If true, prob_tox_samples will return a data-frame of samples.
}
\examples{
# CRM example
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
outcomes <- '1NNN 2NTN'
fit <- get_dfcrm(skeleton = skeleton, target = target) \%>\% fit(outcomes)
fit \%>\% supports_sampling()
}
