% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skellam-distribution.R
\name{Skellam}
\alias{Skellam}
\alias{dskellam}
\alias{rskellam}
\title{Skellam distribution}
\usage{
dskellam(x, mu1, mu2, log = FALSE)

rskellam(n, mu1, mu2)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu1, mu2}{positive valued parameters.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the Skellam distribution.
}
\details{
If \eqn{X} and \eqn{Y} follow Poisson distributions with means
\eqn{\mu_1}{\mu[1]} and \eqn{\mu_2}{\mu[2]}, than \eqn{X-Y} follows
Skellam distribution.

Probability mass function
\deqn{
f(x) = e^{-(\mu_1\!+\!\mu_2)} \left(\frac{\mu_1}{\mu_2}\right)^{k/2}\!\!I_{k}(2\sqrt{\mu_1\mu_2})
}{
f(x) = exp(-(\mu1+\mu2)) * (\mu1/\mu2)^(x/2) * besselI(2*sqrt(\mu1*\mu2), x)
}
}
\examples{

x <- rskellam(1e5, 5, 13)
xx <- -40:40
plot(prop.table(table(x)), type = "h")
lines(xx, dskellam(xx, 5, 13), col = "red")

}
\references{
Karlis, D., & Ntzoufras, I. (2006). Bayesian analysis of the differences of count data.
Statistics in medicine, 25(11), 1885-1905.
}
\keyword{distribution}

