% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zero-inflated-poisson-distribution.R
\name{ZIP}
\alias{ZIP}
\alias{dzip}
\alias{pzip}
\alias{qzip}
\alias{rzip}
\title{Zero-inflated Poisson distribution}
\usage{
dzip(x, lambda, pi, log = FALSE)

pzip(q, lambda, pi, lower.tail = TRUE, log.p = FALSE)

qzip(p, lambda, pi, lower.tail = TRUE, log.p = FALSE)

rzip(n, lambda, pi)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{lambda}{vector of (non-negative) means.}

\item{pi}{probability of extra zeros.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the zero-inflated Poisson distribution.
}
\details{
Probability density function
\deqn{
f(x) = \left\{\begin{array}{ll}
\pi + (1 - \pi) e^{-\lambda} & x = 0 \\
(1 - \pi) \frac{\lambda^{x} e^{-\lambda}} {x!} & x > 0 \\
\end{array}\right.
}{
f(x) = [if x = 0:] (1-\pi)+\pi * exp(-\lambda) [else:] (1-\pi) * dpois(x, lambda)
}
}
\examples{

x <- rzip(1e5, 6, 0.33)
xx <- -2:20
plot(prop.table(table(x)), type = "h")
lines(xx, dzip(xx, 6, 0.33), col = "red")
plot(ecdf(x))
lines(xx, pzip(xx, 6, 0.33), col = "red")

}
\seealso{
\code{\link[stats]{Poisson}}
}
\keyword{distribution}

