% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fairadapt.R
\name{fairadapt}
\alias{fairadapt}
\title{Fairadapt}
\usage{
fairadapt(
  formula,
  prot.attr,
  adj.mat,
  train.data,
  test.data = NULL,
  cfd.mat = NULL,
  top.ord = NULL,
  res.vars = NULL,
  quant.method = rangerQuants,
  visualize.graph = FALSE,
  ...
)
}
\arguments{
\item{formula}{Object of class \code{formula} describing the response and
the covariates.}

\item{prot.attr}{A value of class \code{character} describing the binary
protected attribute. Must be one of the entries of \code{colnames(adj.mat)}.}

\item{adj.mat}{Matrix of class \code{matrix} encoding the relationships in
the causal graph. \code{M[i,j] == 1L} implies the existence of an edge from
node i to node j. Must include all the variables appearing in the formula
object. When the \code{adj.mat} argument is set to \code{NULL}, then the
\code{top.ord} argument has to be supplied.}

\item{train.data, test.data}{Training data & testing data, both of class
\code{data.frame}. Test data is by default \code{NULL}.}

\item{cfd.mat}{Symmetric matrix of class \code{matrix} encoding the
bidirected edges in the causal graph. \code{M[i,j] == M[j, i] == 1L}
implies the existence of a bidirected edge between nodes i and j. Must
include all the variables appearing in the formula object.}

\item{top.ord}{A vector of class \code{character} describing the
topological ordering of the causal graph. Default value is \code{NULL},
but this argument must be supplied if \code{adj.mat} is not specified.
Also must include all the variables appearing in the formula object.}

\item{res.vars}{A vector of class \code{character} listing all the resolving
variables, which should not be changed by the adaption procedure. Default
value is \code{NULL}, corresponding to no resolving variables. Resolving
variables should be a subset of the descendants of the protected attribute.}

\item{quant.method}{A function choosing the method used for quantile
regression. Default value is \code{rangerQuants} (using random forest
quantile regression). Other implemented options are \code{linearQuants} and
\code{mcqrnnQuants}. A custom function can be supplied by the user here,
and the associated method for the S3 generic \code{computeQuants} needs to be
added.}

\item{visualize.graph}{A \code{logical} indicating whether the causal graph
should be plotted upon calling the \code{fairadapt()} function. Default
value is \code{FALSE}.}

\item{...}{Additional arguments forwarded to the function passed as
`quant.method`.}
}
\value{
An object of class \code{fairadapt}, containing the original and
adapted training and testing data, together with the causal graph and some
additional meta-information.
}
\description{
Implementation of fair data adaptation with quantile preservation
(Plecko & Meinshausen 2019). Uses only plain \code{R}.
}
\details{
The procedure takes the training and testing data as an input, together with
the causal graph given by an adjacency matrix and the list of resolving
variables, which should be kept fixed during the adaptation procedure. The
procedure then calculates a fair representation of the data, after which
any classification method can be used. There are, however, several valid
training options yielding fair predictions, and the best of them can be
chosen with cross-validation. For more details we refer the user to the
original paper. Most of the running time is due to the quantile regression
step using the ranger package.
}
\examples{
uni.adj.mat <- array(0, dim = c(4, 4))
colnames(uni.adj.mat) <- rownames(uni.adj.mat) <-
  c("gender", "edu", "test", "score")

uni.adj.mat["gender", c("edu", "test")] <-
  uni.adj.mat["edu", c("test", "score")] <-
  uni.adj.mat["test", "score"] <- 1L

FA <- fairadapt(score ~ .,
  train.data = uni_admission[1:100, ],
  test.data = uni_admission[101:150, ],
  adj.mat = uni.adj.mat, prot.attr = "gender")

FA

}
\references{
Plecko, D. & Meinshausen, N. (2019).
Fair Data Adaptation with Quantile Preservation \cr
}
\author{
Drago Plecko
}
