% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbroc.methods.R
\name{plot.fbroc.roc}
\alias{plot.fbroc.roc}
\title{Plots a \code{fbroc.roc} object}
\usage{
\method{plot}{fbroc.roc}(x, col = "blue", fill = "royalblue1",
  print.plot = TRUE, show.conf = TRUE, steps = 250, conf.level = 0.95,
  show.metric = NULL, text.size.perf = 6, show.area = !show.conf, ...)
}
\arguments{
\item{x}{Object of class \code{fbroc.roc}.}

\item{col}{Color used for the curve. Defaults to blue.}

\item{fill}{Color used for areas (confidence regions, AUCs and partial AUCs).}

\item{print.plot}{Logical specifying whether the plot should be printed.}

\item{show.conf}{Logical specifying whether the confidence region should be
plotted.}

\item{steps}{Number of discrete steps for the FPR at which the TPR is 
calculated. TPR confidence intervals are given for all FPRs in 
\code{seq(0, 1, by = (1 / steps))}. Defaults to 250.}

\item{conf.level}{Confidence level of the confidence region.}

\item{show.metric}{Character specifying which metric to display. See 
\code{\link{perf.fbroc.roc}} for details. Defaults to \code{NULL}, which means
that no metric is displayed.}

\item{text.size.perf}{Size of the text display when show.metric is set to \code{TRUE}.
Defaults to 6.}

\item{show.area}{Whether to shade the AUC or partial AUC area. Defaults to !show.conf.}

\item{...}{further arguments passed to \code{\link{perf.fbroc.roc}}.}
}
\value{
A ggplot, so that the user can customize the plot further.
}
\description{
Plot a \code{fbroc.roc} object and shows the ROC curve. The confidence
region for the ROC curve and the result for a specified performance metric 
can also be included in the plot.
}
\examples{
y <- rep(c(TRUE, FALSE), each = 100)
x <- rnorm(200) + y
result.boot <- boot.roc(x, y, n.boot = 100)
plot(result.boot)
plot(result.boot, show.metric = "auc")
plot(result.boot, show.metric = "auc", show.conf = FALSE) # show area instead
plot(result.boot, show.metric = "tpr", fpr = 0.2)
plot(result.boot, show.metric = "partial.auc", fpr = c(0, 0.5),
     show.partial.auc.warning = FALSE)
plot(result.boot, show.metric = "partial.auc", fpr = c(0, 0.5), show.conf = FALSE,
     show.partial.auc.warning = FALSE)  # show area instead
}
\seealso{
\code{\link{boot.roc}}, \code{\link{perf.fbroc.roc}}
}

