% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_coords}
\alias{g_coords}
\title{Extract coordinate values from geometries}
\usage{
g_coords(geom)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}
}
\value{
A data frame as returned by \code{wk::wk_coords()}: columns \code{feature_id}
(the index of the feature from the input), \code{part_id} (an arbitrary integer
identifying the point, line, or polygon from whence it came), \code{ring_id} (an
arbitrary integer identifying individual rings within polygons), and one
column per coordinate (\code{x}, \code{y}, and/or \code{z} and/or \code{m}).
}
\description{
\code{g_coords()} extracts coordinate values (vertices) from the input geometries
and returns a data frame with coordinates as columns.
}
\examples{
dsn <- system.file("extdata/ynp_fires_1984_2022.gpkg", package="gdalraster")
lyr <- new(GDALVector, dsn)
d <- lyr$fetch(10)

vertices <- g_coords(d$geom)
head(vertices)

lyr$close()
}
