% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/early_day_motions.R
\name{early_day_motions}
\alias{early_day_motions}
\title{early_day_motions}
\usage{
early_day_motions(edm_id = NULL, session = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), signatures = 1,
  extra_args = NULL, tidy = TRUE)
}
\arguments{
\item{edm_id}{Accepts the ID number of an early day motion, and returns data on that motion. Note that EDM numbers reset each parliamentary session, so using this as the only parameter will return multiple early day motions. Defaults to NULL.}

\item{session}{Accepts a parliamentary session, in yyyy/yy format. Defaults to NULL.}

\item{start_date}{The earliest date to include in the data frame, if calling all early day motions. Defaults to '1900-01-01'.}

\item{end_date}{The latest date to include in the data frame, if calling all early day motions. Defaults to current system date.}

\item{signatures}{The minimum number of signatures required for inclusion in the data frame. Defaults to 1.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Imports data on early day motions
}
\examples{
\dontrun{

x <- early_day_motions(edm_id = 1073)

x <- early_day_motions(edm_id = 1073, session='2015/16')

}
}
\keyword{EDM}
