% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_evaluator.R
\name{fm_is_within}
\alias{fm_is_within}
\alias{fm_is_within.default}
\title{Query if points are inside a mesh}
\usage{
fm_is_within(x, y, ...)

\method{fm_is_within}{default}(x, y, ...)
}
\arguments{
\item{x}{A set of points of a class supported by \code{fm_evaluator(y, loc = x)}}

\item{y}{An \code{inla.mesh}}

\item{\dots}{Currently unused}
}
\value{
A logical vector
}
\description{
Queries whether each input point is within a mesh or not.
}
\examples{
\dontrun{
if (bru_safe_inla(quietly = TRUE)) {
  # Load Gorilla data

  data("gorillas", package = "inlabru")

  # Check if all Gorilla nests are inside the mesh

  all(fm_is_within(gorillas$nests, gorillas$mesh))

  # Also works for locations not stored as SpatialPoints object

  loc <- coordinates(gorillas$nests)
  all(fm_is_within(loc, gorillas$mesh))
}
}
}
