% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetMeasureOptions}
\alias{GetMeasureOptions}
\title{Options for 'Measuring Performance'}
\usage{
GetMeasureOptions(
  typesIn = NULL,
  typesOut = NULL,
  simFixSize = 10L,
  trainRatio = 0.75,
  trainFixSize = 0L,
  seed = 0L,
  horizons = NULL,
  weightedEval = FALSE
)
}
\arguments{
\item{typesIn}{(nullable string vector) Evaluations when model is estimated using all available data. It can be \code{aic}, \code{sic}, \code{costMatrixIn}, \code{aucIn}. Null means no measure.}

\item{typesOut}{(nullable string vector) Evaluations in an pseudo out-of-sample simulation. It can be \code{sign}, \code{direction}, \code{rmse}, \code{scaledRmse}, \code{mae}, \code{scaledMae}, \code{crps}, \code{costMatrixOut}, \code{aucOut}. Null means no measure.}

\item{simFixSize}{(int) Number of pseudo out-of-sample simulations. Use zero to disable the simulation.}

\item{trainRatio}{(double) Number of data-points, as a ratio of the available size, in the training sample in the pseudo out-of-sample simulation.}

\item{trainFixSize}{(int) Number of data-points in the training sample in the pseudo out-of-sample simulation. If zero, \code{trainRatio} will be used.}

\item{seed}{(int) A seed for random number generator. Use zero for a random value.}

\item{horizons}{(nullable integer vector) prediction horizons to be used in pseudo out-of-sample simulations, if model supports time-series prediction. If null, c(1) is used.}

\item{weightedEval}{(bool) If true, weights are used in evaluationg discrete-choice models}
}
\value{
A list with the given options.
}
\description{
Options for 'Measuring Performance'
}
