% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{get_signature}
\alias{get_signature}
\alias{get_signature.character}
\alias{get_signature.tbl}
\alias{get_signature.fs_path}
\title{Detect File Signature}
\usage{
get_signature(x, ...)

\method{get_signature}{character}(x, ...)

\method{get_signature}{tbl}(x, ...)

\method{get_signature}{fs_path}(x, ...)
}
\arguments{
\item{x}{object of which the signature has to be determined}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
Detected file signature. Currently "OSPAR", "long", and "wide"
        are recognized. In case of an unknown file signature, "unknown"
        is returned (character vector of length 1).
}
\description{
Generic function for detecting the file signature.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: detect file signature from \code{character}.

\item \code{tbl}: detect file signature from a tibble (\code{tbl}).

\item \code{fs_path}: detect file signature from \code{fs_path}.
}}

