% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convexLogisticPCA.R
\name{convexLogisticPCA}
\alias{convexLogisticPCA}
\title{Convex Logistic Principal Component Analysis}
\usage{
convexLogisticPCA(x, k = 2, M = 4, quiet = TRUE, use_irlba = FALSE,
  max_iters = 1000, conv_criteria = 1e-06, random_start = FALSE, start_H,
  mu, main_effects = TRUE, ss_factor = 4, weights)
}
\arguments{
\item{x}{matrix with all binary entries}

\item{k}{number of principal components to return}

\item{M}{value to approximate the saturated model}

\item{quiet}{logical; whether the calculation should give feedback}

\item{use_irlba}{logical; if \code{TRUE}, the function uses the irlba package
to more quickly calculate the eigen-decomposition}

\item{max_iters}{number of maximum iterations}

\item{conv_criteria}{convergence criteria. The difference between average deviance
in successive iterations}

\item{random_start}{logical; whether to randomly inititalize the parameters. If \code{FALSE},
function will use an eigen-decomposition as starting value}

\item{start_H}{starting value for the Fantope matrix}

\item{mu}{main effects vector. Only used if \code{main_effects = TRUE}}

\item{main_effects}{logical; whether to include main effects in the model}

\item{ss_factor}{step size multiplier. Amount by which to multiply the step size. Quadratic
convergence rate can be proven for \code{ss_factor = 1}, but I have found higher values
sometimes work better. The default is \code{ss_factor = 4}.
If it is not converging, try \code{ss_factor = 1}.}

\item{weights}{an optional matrix of the same size as the \code{x} with non-negative weights}
}
\value{
An S3 object of class \code{clpca} which is a list with the
following components:
\item{mu}{the main effects}
\item{H}{a rank \code{k} Fantope matrix}
\item{U}{a \code{ceiling(k)}-dimentional orthonormal matrix with the loadings}
\item{PCs}{the princial component scores}
\item{M}{the parameter inputed}
\item{iters}{number of iterations required for convergence}
\item{loss_trace}{the trace of the average negative log likelihood using the Fantope matrix}
\item{proj_loss_trace}{the trace of the average negative log likelihood using the projection matrix}
\item{prop_deviance_expl}{the proportion of deviance explained by this model.
   If \code{main_effects = TRUE}, the null model is just the main effects, otherwise
   the null model estimates 0 for all natural parameters.}
}
\description{
Dimensionality reduction for binary data by extending Pearson's
PCA formulation to minimize Binomial deviance. The convex relaxation
to projection matrices, the Fantope, is used.
}
\examples{
# construct a low rank matrix in the logit scale
rows = 100
cols = 10
set.seed(1)
mat_logit = outer(rnorm(rows), rnorm(cols))

# generate a binary matrix
mat = (matrix(runif(rows * cols), rows, cols) <= inv.logit.mat(mat_logit)) * 1.0

# run convex logistic PCA on it
clpca = convexLogisticPCA(mat, k = 1, M = 4)
}

