% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milr.R
\name{milr}
\alias{milr}
\title{Maximum likelihood estimation of multiple-instance logistic regression with LASSO penalty}
\usage{
milr(y, x, bag, lambda = 0, lambdaCriterion = "BIC", nfold = 10,
  maxit = 500)
}
\arguments{
\item{y}{a vector. Bag-level binary labels.}

\item{x}{the design matrix. The number of rows of \code{x} must be equal to the length of \code{y}.}

\item{bag}{a vector, bag id.}

\item{lambda}{the tuning parameter for LASSO-penalty.  If \code{lambda} is a real value number, then the \code{milr} 
fits the model based on this lambda value.  Second, if \code{lambda} is vector, then the optimal lambda value would be
be chosen based on the optimality criterion, \code{lambdaCriterion}.  
Finally, if \code{lambda = -1}, then the optimal lambda value would be chosen automatically.
The default is 0.}

\item{lambdaCriterion}{a string, the used optimality criterion for tuning the \code{lambda} value.
It can be specified with \code{lambdaCriterion = "BIC"} or \code{lambdaCriterion = "deviance"}.}

\item{nfold}{an integer, the number of fold for cross-validation to choose the optimal \code{lambda} when
\code{lambdaCriterion = "deviance"}.}

\item{maxit}{an integer, the maximum iteration for the EM algorithm.}
}
\value{
a list including deviance (not cv deviance), BIC, chosen lambda, coefficients, 
 fitted values, log-likelihood and variances of coefficients.
}
\description{
Please refer to \link{milr-package}.
}
\examples{
set.seed(100)
beta <- runif(5, -5, 5)
trainData <- DGP(70, 3, beta)
testData <- DGP(30, 3, beta)
# default (not use LASSO)
milr_result <- milr(trainData$Z, trainData$X, trainData$ID)
coef(milr_result)      # coefficients
fitted(milr_result)    # fitted values
summary(milr_result)   # summary milr
predict(milr_result, testData$X, testData$ID) # predicted label

# use BIC to choose penalty
milr_result <- milr(trainData$Z, trainData$X, trainData$ID,
  exp(seq(log(0.01), log(50),length = 30)))
coef(milr_result)      # coefficients
fitted(milr_result)    # fitted values
summary(milr_result)   # summary milr
predict(milr_result, testData$X, testData$ID) # predicted label

# use auto-tuning
milr_result <- milr(trainData$Z, trainData$X, trainData$ID, lambda = -1)
coef(milr_result)      # coefficients
fitted(milr_result)    # fitted values
summary(milr_result)   # summary milr
predict(milr_result, testData$X, testData$ID) # predicted label

# use cv in auto-tuning
milr_result <- milr(trainData$Z, trainData$X, trainData$ID, 
                    lambda = -1, lambdaCriterion = "deviance")
coef(milr_result)      # coefficients
fitted(milr_result)    # fitted values
summary(milr_result)   # summary milr
predict(milr_result, testData$X, testData$ID) # predicted label
}

