% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibullpar.R
\name{to_mu_sd_weibull}
\alias{to_mu_sd_weibull}
\title{Parameter Conversion for Weibull Distribution}
\usage{
to_mu_sd_weibull(k, lambda)
}
\arguments{
\item{k}{a numeric vector representing the shape of a series of Weibull distributions}

\item{lambda}{a numeric vector representing the scale of a series of Weibull distributions.
\code{k} and \code{lambda} should have the same length.}
}
\value{
a list of two items
\item{mu}{a vector of the means of Weibull distributions}
\item{sd}{a vector of the standard deviations of Weibull distributions}
}
\description{
The function \code{to_mu_sd_weibull} converts the parameters of shape and scale of weibull distributions to
the parameters of the mean and standard deviation.
}
\details{
The purpose of this function is to convert the parameterization of Weibull distribution in the form of
shape and scale to the form of mean and standard deviation.
}
\examples{
to_mu_sd_weibull(2, 1)
to_mu_sd_weibull(c(2, 4), c(1, 1))

}
\seealso{
\code{\link{to_k_lambda_weibull}}
}
