% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/concurrence.R
\name{concurrenceReport}
\alias{concurrenceReport}
\title{Generates a label concurrence report}
\usage{
concurrenceReport(mld, pdfOutput = FALSE, file = "Rconcurrence.pdf")
}
\arguments{
\item{mld}{\code{mldr} object to analyze}

\item{pdfOutput}{Boolean value indicating if the output has to be sent to a PDF file. Defaults to true, so the output is shown in the console.}

\item{file}{If the \code{pdfOutput} parameter is \code{true} the output will be written in the file specified by this parameter. The default file name is \code{Rocurrence.pdf}.}
}
\value{
None
}
\description{
This function produces a label concurrence report, providing the average SCUMBLE, SCUMBLE by label, a list with the minority labels
most affected by this problem indicating which majority labels they appear with, and a concurrence plot. The report output is written in the
standard output by default, but it could be redirected to a PDF file.
}
\examples{
library(mldr)
\dontrun{
concurrenceReport(birds)
}
}
\seealso{
\code{\link{remedial}}, \code{\link{labelInteractions}}
}

