% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleCoordsToHabitatGrid.R
\name{scaleCoordsToHabitatGrid}
\alias{scaleCoordsToHabitatGrid}
\title{Scale x- and y-coordinates to grid cells coordinates.}
\usage{
scaleCoordsToHabitatGrid(
  coordsData = coordsData,
  coordsHabitatGridCenter = coordsHabitatGridCenter,
  scaleToGrid = TRUE
)
}
\arguments{
\item{coordsData}{A matrix or array of x- and y-coordinates to be scaled to the habitat grid. x- and y- coordinates must be identified using "x" and "y" dimnames.}

\item{coordsHabitatGridCenter}{A matrix of x- and y-coordinates for each habitat grid cell center.}

\item{scaleToGrid}{Defaults to TRUE. If FALSE, coordsData are already scaled and will be rescaled to its original coordinates.}
}
\value{
This function returns a list of objects:
\itemize{
\item coordsDataScaled: A matrix or array of scaled (rescaled if scaleToGrid==FALSE) x- and y-coordinates for coordsData.
\item coordsHabitatGridCenterScaled: A matrix of scaled x- and y-cell coordinates for coordsHabitatGridCenter.
}
}
\description{
R utility function to scale x- and y- coordinates to the habitat grid.
Scaling the coordinates to the habitat grid allows implementation of the fast look-up approach to identify the habitat grid cell in which a point is located. 
This technique was first applied by Mike Meredith in SCR (\href{https://mmeredith.net/blog/2013/1309_SECR_in_JAGS_patchy_habitat.htm}{https://mmeredith.net/blog/2013/1309_SECR_in_JAGS_patchy_habitat.htm}).
Re-scaling the entire coordinate system of the data input is a requirement to run SCR models with the local evaluation approach. 
This function requires square grid cells and coordinates using projection with units in meters or km (e.g., UTM but not latitude/longitude)
}
\examples{
coordsGridCenter <- expand.grid(list(x = seq(50.5, 100, 1),
                                    y = seq(100.5, 150, 1)))
coordsData <- expand.grid(list(x = seq(60, 90, 1),
                             y = seq(110, 140, 1)))
plot(coordsGridCenter[,2]~coordsGridCenter[,1])
points(coordsData[,2]~coordsData[,1], col="red")
scaled <- scaleCoordsToHabitatGrid(coordsData = coordsData
                                  , coordsHabitatGridCenter = coordsGridCenter)
plot(scaled$coordsHabitatGridCenterScaled[,2]~scaled$coordsHabitatGridCenterScaled[,1])
points(scaled$coordsDataScaled[,2]~scaled$coordsDataScaled[,1], col="red")

}
\author{
Richard Bischof, Cyril Milleret
}
