% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixrGrad.R
\name{nlmixr2Gill83}
\alias{nlmixr2Gill83}
\title{Get the optimal forward difference interval by Gill83 method}
\usage{
nlmixr2Gill83(
  what,
  args,
  envir = parent.frame(),
  which,
  gillRtol = sqrt(.Machine$double.eps),
  gillK = 10L,
  gillStep = 2,
  gillFtol = 0
)
}
\arguments{
\item{what}{either a function or a non-empty character string naming the
    function to be called.}

\item{args}{a \emph{list} of arguments to the function call.  The
    \code{names} attribute of \code{args} gives the argument names.}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}

\item{which}{Which parameters to calculate the forward difference
and optimal forward difference interval}

\item{gillRtol}{The relative tolerance used for Gill 1983
determination of optimal step size.}

\item{gillK}{The total number of possible steps to determine the
optimal forward/central difference step size per parameter (by
the Gill 1983 method).  If 0, no optimal step size is
determined.  Otherwise this is the optimal step size
determined.}

\item{gillStep}{When looking for the optimal forward difference
step size, this is This is the step size to increase the
initial estimate by.  So each iteration the new step size =
(prior step size)*gillStep}

\item{gillFtol}{The gillFtol is the gradient error tolerance that
is acceptable before issuing a warning/error about the gradient estimates.}
}
\value{
A data frame with the following columns:

- info Gradient evaluation/forward difference information

- hf Forward difference final estimate

- df Derivative estimate

- df2 2nd Derivative Estimate

- err Error of the final estimate derivative

- aEps Absolute difference for forward numerical differences

- rEps Relative Difference for backward numerical differences

- aEpsC Absolute difference for central numerical differences

- rEpsC Relative difference for central numerical differences

The \code{info} returns one of the following:

- "Not Assessed" Gradient wasn't assessed

- "Good Success" in Estimating optimal forward difference interval

- "High Grad Error" Large error; Derivative estimate error \code{fTol} or more of the derivative

- "Constant Grad" Function constant or nearly constant for this parameter

- "Odd/Linear Grad" Function odd or nearly linear, df = K, df2 ~ 0

- "Grad changes quickly" df2 increases rapidly as h decreases
}
\description{
Get the optimal forward difference interval by Gill83 method
}
\examples{

## These are taken from the numDeriv::grad examples to show how
## simple gradients are assessed with nlmixr2Gill83

nlmixr2Gill83(sin, pi)

nlmixr2Gill83(sin, (0:10)*2*pi/10)

func0 <- function(x){ sum(sin(x))  }
nlmixr2Gill83(func0 , (0:10)*2*pi/10)

func1 <- function(x){ sin(10*x) - exp(-x) }
curve(func1,from=0,to=5)

x <- 2.04
numd1 <- nlmixr2Gill83(func1, x)
exact <- 10*cos(10*x) + exp(-x)
c(numd1$df, exact, (numd1$df - exact)/exact)

x <- c(1:10)
numd1 <- nlmixr2Gill83(func1, x)
exact <- 10*cos(10*x) + exp(-x)
cbind(numd1=numd1$df, exact, err=(numd1$df - exact)/exact)

sc2.f <- function(x){
  n <- length(x)
   sum((1:n) * (exp(x) - x)) / n
}

sc2.g <- function(x){
  n <- length(x)
  (1:n) * (exp(x) - 1) / n
}

x0 <- rnorm(100)
exact <- sc2.g(x0)

g <- nlmixr2Gill83(sc2.f, x0)

max(abs(exact - g$df)/(1 + abs(exact)))

}
\author{
Matthew Fidler
}
