% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_restore_db_cluster_to_point_in_time}
\alias{docdb_restore_db_cluster_to_point_in_time}
\title{Restores a cluster to an arbitrary point in time}
\usage{
docdb_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
  SourceDBClusterIdentifier, RestoreToTime, UseLatestRestorableTime, Port,
  DBSubnetGroupName, VpcSecurityGroupIds, Tags, KmsKeyId,
  EnableCloudwatchLogsExports, DeletionProtection)
}
\arguments{
\item{DBClusterIdentifier}{[required] The name of the new cluster to be created.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{SourceDBClusterIdentifier}{[required] The identifier of the source cluster from which to restore.

Constraints:
\itemize{
\item Must match the identifier of an existing \code{DBCluster}.
}}

\item{RestoreToTime}{The date and time to restore the cluster to.

Valid values: A time in Universal Coordinated Time (UTC) format.

Constraints:
\itemize{
\item Must be before the latest restorable time for the instance.
\item Must be specified if the \code{UseLatestRestorableTime} parameter is not
provided.
\item Cannot be specified if the \code{UseLatestRestorableTime} parameter is
\code{true}.
\item Cannot be specified if the \code{RestoreType} parameter is
\code{copy-on-write}.
}

Example: \verb{2015-03-07T23:45:00Z}}

\item{UseLatestRestorableTime}{A value that is set to \code{true} to restore the cluster to the latest
restorable backup time, and \code{false} otherwise.

Default: \code{false}

Constraints: Cannot be specified if the \code{RestoreToTime} parameter is
provided.}

\item{Port}{The port number on which the new cluster accepts connections.

Constraints: Must be a value from \code{1150} to \code{65535}.

Default: The default port for the engine.}

\item{DBSubnetGroupName}{The subnet group name to use for the new cluster.

Constraints: If provided, must match the name of an existing
\code{DBSubnetGroup}.

Example: \code{mySubnetgroup}}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new cluster belongs to.}

\item{Tags}{The tags to be assigned to the restored cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted cluster
from an encrypted cluster.

The AWS KMS key identifier is the Amazon Resource Name (ARN) for the AWS
KMS encryption key. If you are restoring a cluster with the same AWS
account that owns the AWS KMS encryption key used to encrypt the new
cluster, then you can use the AWS KMS key alias instead of the ARN for
the AWS KMS encryption key.

You can restore to a new cluster and encrypt the new cluster with an AWS
KMS key that is different from the AWS KMS key used to encrypt the
source cluster. The new DB cluster is encrypted with the AWS KMS key
identified by the \code{KmsKeyId} parameter.

If you do not specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the cluster is encrypted, then the restored cluster is encrypted
using the AWS KMS key that was used to encrypt the source cluster.
\item If the cluster is not encrypted, then the restored cluster is not
encrypted.
}

If \code{DBClusterIdentifier} refers to a cluster that is not encrypted, then
the restore request is rejected.}

\item{EnableCloudwatchLogsExports}{A list of log types that must be enabled for exporting to Amazon
CloudWatch Logs.}

\item{DeletionProtection}{Specifies whether this cluster can be deleted. If \code{DeletionProtection}
is enabled, the cluster cannot be deleted unless it is modified and
\code{DeletionProtection} is disabled. \code{DeletionProtection} protects clusters
from being accidentally deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBCluster = list(
    AvailabilityZones = list(
      "string"
    ),
    BackupRetentionPeriod = 123,
    DBClusterIdentifier = "string",
    DBClusterParameterGroup = "string",
    DBSubnetGroup = "string",
    Status = "string",
    PercentProgress = "string",
    EarliestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Endpoint = "string",
    ReaderEndpoint = "string",
    MultiAZ = TRUE|FALSE,
    Engine = "string",
    EngineVersion = "string",
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Port = 123,
    MasterUsername = "string",
    PreferredBackupWindow = "string",
    PreferredMaintenanceWindow = "string",
    DBClusterMembers = list(
      list(
        DBInstanceIdentifier = "string",
        IsClusterWriter = TRUE|FALSE,
        DBClusterParameterGroupStatus = "string",
        PromotionTier = 123
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    HostedZoneId = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbClusterResourceId = "string",
    DBClusterArn = "string",
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        Status = "string"
      )
    ),
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
Restores a cluster to an arbitrary point in time. Users can restore to
any point in time before \code{LatestRestorableTime} for up to
\code{BackupRetentionPeriod} days. The target cluster is created from the
source cluster with the same configuration as the original cluster,
except that the new cluster is created with the default security group.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_to_point_in_time(
  DBClusterIdentifier = "string",
  SourceDBClusterIdentifier = "string",
  RestoreToTime = as.POSIXct(
    "2015-01-01"
  ),
  UseLatestRestorableTime = TRUE|FALSE,
  Port = 123,
  DBSubnetGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
