% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_batch_apply_update_action}
\alias{elasticache_batch_apply_update_action}
\title{Apply the service update}
\usage{
elasticache_batch_apply_update_action(ReplicationGroupIds,
  CacheClusterIds, ServiceUpdateName)
}
\arguments{
\item{ReplicationGroupIds}{The replication group IDs}

\item{CacheClusterIds}{The cache cluster IDs}

\item{ServiceUpdateName}{[required] The unique ID of the service update}
}
\value{
A list with the following syntax:\preformatted{list(
  ProcessedUpdateActions = list(
    list(
      ReplicationGroupId = "string",
      CacheClusterId = "string",
      ServiceUpdateName = "string",
      UpdateActionStatus = "not-applied"|"waiting-to-start"|"in-progress"|"stopping"|"stopped"|"complete"|"scheduling"|"scheduled"|"not-applicable"
    )
  ),
  UnprocessedUpdateActions = list(
    list(
      ReplicationGroupId = "string",
      CacheClusterId = "string",
      ServiceUpdateName = "string",
      ErrorType = "string",
      ErrorMessage = "string"
    )
  )
)
}
}
\description{
Apply the service update. For more information on service updates and
applying them, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html}{Applying Service Updates}.
}
\section{Request syntax}{
\preformatted{svc$batch_apply_update_action(
  ReplicationGroupIds = list(
    "string"
  ),
  CacheClusterIds = list(
    "string"
  ),
  ServiceUpdateName = "string"
)
}
}

\keyword{internal}
