% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_modify_user}
\alias{elasticache_modify_user}
\title{Changes user password(s) and/or access string}
\usage{
elasticache_modify_user(UserId, AccessString, AppendAccessString,
  Passwords, NoPasswordRequired)
}
\arguments{
\item{UserId}{[required] The ID of the user.}

\item{AccessString}{Access permissions string used for this user.}

\item{AppendAccessString}{Adds additional user permissions to the access string.}

\item{Passwords}{The passwords belonging to the user. You are allowed up to two.}

\item{NoPasswordRequired}{Indicates no password is required for the user.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserId = "string",
  UserName = "string",
  Status = "string",
  Engine = "string",
  AccessString = "string",
  UserGroupIds = list(
    "string"
  ),
  Authentication = list(
    Type = "password"|"no-password",
    PasswordCount = 123
  ),
  ARN = "string"
)
}
}
\description{
Changes user password(s) and/or access string.
}
\section{Request syntax}{
\preformatted{svc$modify_user(
  UserId = "string",
  AccessString = "string",
  AppendAccessString = "string",
  Passwords = list(
    "string"
  ),
  NoPasswordRequired = TRUE|FALSE
)
}
}

\keyword{internal}
