% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_describe_engine_default_cluster_parameters}
\alias{neptune_describe_engine_default_cluster_parameters}
\title{Returns the default engine and system parameter information for the
cluster database engine}
\usage{
neptune_describe_engine_default_cluster_parameters(
  DBParameterGroupFamily, Filters, MaxRecords, Marker)
}
\arguments{
\item{DBParameterGroupFamily}{[required] The name of the DB cluster parameter group family to return engine
parameter information for.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=neptune_describe_engine_default_cluster_parameters]{describe_engine_default_cluster_parameters}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\value{
A list with the following syntax:\preformatted{list(
  EngineDefaults = list(
    DBParameterGroupFamily = "string",
    Marker = "string",
    Parameters = list(
      list(
        ParameterName = "string",
        ParameterValue = "string",
        Description = "string",
        Source = "string",
        ApplyType = "string",
        DataType = "string",
        AllowedValues = "string",
        IsModifiable = TRUE|FALSE,
        MinimumEngineVersion = "string",
        ApplyMethod = "immediate"|"pending-reboot"
      )
    )
  )
)
}
}
\description{
Returns the default engine and system parameter information for the
cluster database engine.
}
\section{Request syntax}{
\preformatted{svc$describe_engine_default_cluster_parameters(
  DBParameterGroupFamily = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
