% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_failover_db_cluster}
\alias{neptune_failover_db_cluster}
\title{Forces a failover for a DB cluster}
\usage{
neptune_failover_db_cluster(DBClusterIdentifier,
  TargetDBInstanceIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{A DB cluster identifier to force a failover for. This parameter is not
case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing DBCluster.
}}

\item{TargetDBInstanceIdentifier}{The name of the instance to promote to the primary instance.

You must specify the instance identifier for an Read Replica in the DB
cluster. For example, \code{mydbcluster-replica1}.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBCluster = list(
    AllocatedStorage = 123,
    AvailabilityZones = list(
      "string"
    ),
    BackupRetentionPeriod = 123,
    CharacterSetName = "string",
    DatabaseName = "string",
    DBClusterIdentifier = "string",
    DBClusterParameterGroup = "string",
    DBSubnetGroup = "string",
    Status = "string",
    PercentProgress = "string",
    EarliestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Endpoint = "string",
    ReaderEndpoint = "string",
    MultiAZ = TRUE|FALSE,
    Engine = "string",
    EngineVersion = "string",
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Port = 123,
    MasterUsername = "string",
    DBClusterOptionGroupMemberships = list(
      list(
        DBClusterOptionGroupName = "string",
        Status = "string"
      )
    ),
    PreferredBackupWindow = "string",
    PreferredMaintenanceWindow = "string",
    ReplicationSourceIdentifier = "string",
    ReadReplicaIdentifiers = list(
      "string"
    ),
    DBClusterMembers = list(
      list(
        DBInstanceIdentifier = "string",
        IsClusterWriter = TRUE|FALSE,
        DBClusterParameterGroupStatus = "string",
        PromotionTier = 123
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    HostedZoneId = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbClusterResourceId = "string",
    DBClusterArn = "string",
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        Status = "string",
        FeatureName = "string"
      )
    ),
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    CloneGroupId = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
Forces a failover for a DB cluster.

A failover for a DB cluster promotes one of the Read Replicas (read-only
instances) in the DB cluster to be the primary instance (the cluster
writer).

Amazon Neptune will automatically fail over to a Read Replica, if one
exists, when the primary instance fails. You can force a failover when
you want to simulate a failure of a primary instance for testing.
Because each instance in a DB cluster has its own endpoint address, you
will need to clean up and re-establish any existing connections that use
those endpoint addresses when the failover is complete.
}
\section{Request syntax}{
\preformatted{svc$failover_db_cluster(
  DBClusterIdentifier = "string",
  TargetDBInstanceIdentifier = "string"
)
}
}

\keyword{internal}
