% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_remove_source_identifier_from_subscription}
\alias{neptune_remove_source_identifier_from_subscription}
\title{Removes a source identifier from an existing event notification
subscription}
\usage{
neptune_remove_source_identifier_from_subscription(SubscriptionName,
  SourceIdentifier)
}
\arguments{
\item{SubscriptionName}{[required] The name of the event notification subscription you want to remove a
source identifier from.}

\item{SourceIdentifier}{[required] The source identifier to be removed from the subscription, such as the
\strong{DB instance identifier} for a DB instance or the name of a security
group.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventSubscription = list(
    CustomerAwsId = "string",
    CustSubscriptionId = "string",
    SnsTopicArn = "string",
    Status = "string",
    SubscriptionCreationTime = "string",
    SourceType = "string",
    SourceIdsList = list(
      "string"
    ),
    EventCategoriesList = list(
      "string"
    ),
    Enabled = TRUE|FALSE,
    EventSubscriptionArn = "string"
  )
)
}
}
\description{
Removes a source identifier from an existing event notification
subscription.
}
\section{Request syntax}{
\preformatted{svc$remove_source_identifier_from_subscription(
  SubscriptionName = "string",
  SourceIdentifier = "string"
)
}
}

\keyword{internal}
