% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_stop_activity_stream}
\alias{rds_stop_activity_stream}
\title{Stops a database activity stream that was started using the AWS console,
the start-activity-stream AWS CLI command, or the StartActivityStream
action}
\usage{
rds_stop_activity_stream(ResourceArn, ApplyImmediately)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the DB cluster for the database
activity stream. For example,
\code{arn:aws:rds:us-east-1:12345667890:cluster:das-cluster}.}

\item{ApplyImmediately}{Specifies whether or not the database activity stream is to stop as soon
as possible, regardless of the maintenance window for the database.}
}
\description{
Stops a database activity stream that was started using the AWS console,
the \code{start-activity-stream} AWS CLI command, or the
\code{StartActivityStream} action.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html}{Database Activity Streams}
in the \emph{Amazon Aurora User Guide}.
}
\section{Request syntax}{
\preformatted{svc$stop_activity_stream(
  ResourceArn = "string",
  ApplyImmediately = TRUE|FALSE
)
}
}

\keyword{internal}
