% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_event_subscription}
\alias{redshift_modify_event_subscription}
\title{Modifies an existing Amazon Redshift event notification subscription}
\usage{
redshift_modify_event_subscription(SubscriptionName, SnsTopicArn,
  SourceType, SourceIds, EventCategories, Severity, Enabled)
}
\arguments{
\item{SubscriptionName}{[required] The name of the modified Amazon Redshift event notification
subscription.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the SNS topic to be used by the event
notification subscription.}

\item{SourceType}{The type of source that will be generating the events. For example, if
you want to be notified of events generated by a cluster, you would set
this parameter to cluster. If this value is not specified, events are
returned for all Amazon Redshift objects in your AWS account. You must
specify a source type in order to specify source IDs.

Valid values: cluster, cluster-parameter-group, cluster-security-group,
and cluster-snapshot.}

\item{SourceIds}{A list of one or more identifiers of Amazon Redshift source objects. All
of the objects must be of the same type as was specified in the source
type parameter. The event subscription will return only events generated
by the specified objects. If not specified, then events are returned for
all objects within the source type specified.

Example: my-cluster-1, my-cluster-2

Example: my-snapshot-20131010}

\item{EventCategories}{Specifies the Amazon Redshift event categories to be published by the
event notification subscription.

Values: configuration, management, monitoring, security}

\item{Severity}{Specifies the Amazon Redshift event severity to be published by the
event notification subscription.

Values: ERROR, INFO}

\item{Enabled}{A Boolean value indicating if the subscription is enabled. \code{true}
indicates the subscription is enabled}
}
\description{
Modifies an existing Amazon Redshift event notification subscription.
}
\section{Request syntax}{
\preformatted{svc$modify_event_subscription(
  SubscriptionName = "string",
  SnsTopicArn = "string",
  SourceType = "string",
  SourceIds = list(
    "string"
  ),
  EventCategories = list(
    "string"
  ),
  Severity = "string",
  Enabled = TRUE|FALSE
)
}
}

\keyword{internal}
