% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_disable_policy_type}
\alias{organizations_disable_policy_type}
\title{Disables an organizational policy type in a root}
\usage{
organizations_disable_policy_type(RootId, PolicyType)
}
\arguments{
\item{RootId}{[required] The unique identifier (ID) of the root in which you want to disable a
policy type. You can get the ID from the
\code{\link[=organizations_list_roots]{list_roots}} operation.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a root ID
string requires "r-" followed by from 4 to 32 lowercase letters or
digits.}

\item{PolicyType}{[required] The policy type that you want to disable in this root. You can specify
one of the following values:
\itemize{
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html}{AISERVICES_OPT_OUT_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html}{BACKUP_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html}{SERVICE_CONTROL_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html}{TAG_POLICY}
}}
}
\description{
Disables an organizational policy type in a root. A policy of a certain type can be attached to entities in a root only if that type is enabled in the root. After you perform this operation, you no longer can attach policies of the specified type to that root or to any organizational unit (OU) or account in that root. You can undo this by using the \code{\link[=organizations_enable_policy_type]{enable_policy_type}} operation.

See \url{https://www.paws-r-sdk.com/docs/organizations_disable_policy_type/} for full documentation.
}
\keyword{internal}
