% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_create_app}
\alias{resiliencehub_create_app}
\title{Creates an Resilience Hub application}
\usage{
resiliencehub_create_app(
  assessmentSchedule = NULL,
  clientToken = NULL,
  description = NULL,
  name,
  policyArn = NULL,
  tags = NULL
)
}
\arguments{
\item{assessmentSchedule}{Assessment execution schedule with 'Daily' or 'Disabled' values.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{description}{The optional description for an app.}

\item{name}{[required] The name for the application.}

\item{policyArn}{The Amazon Resource Name (ARN) of the resiliency policy. The format for
this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{tags}{The tags assigned to the resource. A tag is a label that you assign to
an Amazon Web Services resource. Each tag consists of a key/value pair.}
}
\description{
Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe an Resilience Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. For more information about the number of resources supported per application, see \href{https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub}{Service Quotas}.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_create_app/} for full documentation.
}
\keyword{internal}
