% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_ops_items}
\alias{ssm_describe_ops_items}
\title{Query a set of OpsItems}
\usage{
ssm_describe_ops_items(
  OpsItemFilters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{OpsItemFilters}{One or more filters to limit the response.
\itemize{
\item Key: CreatedTime

Operations: GreaterThan, LessThan
\item Key: LastModifiedBy

Operations: Contains, Equals
\item Key: LastModifiedTime

Operations: GreaterThan, LessThan
\item Key: Priority

Operations: Equals
\item Key: Source

Operations: Contains, Equals
\item Key: Status

Operations: Equals
\item Key: Title*

Operations: Equals,Contains
\item Key: OperationalData**

Operations: Equals
\item Key: OperationalDataKey

Operations: Equals
\item Key: OperationalDataValue

Operations: Equals, Contains
\item Key: OpsItemId

Operations: Equals
\item Key: ResourceId

Operations: Contains
\item Key: AutomationId

Operations: Equals
}

*The Equals operator for Title matches the first 100 characters. If you
specify more than 100 characters, they system returns an error that the
filter value exceeds the length limit.

**If you filter the response by using the OperationalData operator,
specify a key-value pair by using the following JSON format:
\{"key":"key_name","value":"a_value"\}}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}
}
\description{
Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of OpsItems. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/}{Getting started with OpsCenter} in the \emph{Amazon Web Services Systems Manager User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ssm_describe_ops_items/} for full documentation.
}
\keyword{internal}
