# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cloudwatchinternetmonitor_service.R
NULL

#' Creates a monitor in Amazon CloudWatch Internet Monitor
#'
#' @description
#' Creates a monitor in Amazon CloudWatch Internet Monitor. A monitor is built based on information from the application resources that you add: VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, and Amazon WorkSpaces directories. Internet Monitor then publishes internet measurements from Amazon Web Services that are specific to the *city-networks*. That is, the locations and ASNs (typically internet service providers or ISPs), where clients access your application. For more information, see [Using Amazon CloudWatch Internet Monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html) in the *Amazon CloudWatch User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_create_monitor/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_create_monitor/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param Resources The resources to include in a monitor, which you provide as a set of
#' Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon
#' CloudFront distributions, or Amazon WorkSpaces directories.
#' 
#' You can add a combination of VPCs and CloudFront distributions, or you
#' can add WorkSpaces directories, or you can add NLBs. You can't add NLBs
#' or WorkSpaces directories together with any other resources.
#' 
#' If you add only Amazon VPC resources, at least one VPC must have an
#' Internet Gateway attached to it, to make sure that it has internet
#' connectivity.
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters that you
#' specify to make an idempotent API request. Don't reuse the same client
#' token for other API requests.
#' @param Tags The tags for a monitor. You can add a maximum of 50 tags in Internet
#' Monitor.
#' @param MaxCityNetworksToMonitor The maximum number of city-networks to monitor for your resources. A
#' city-network is the location (city) where clients access your
#' application resources from and the ASN or network provider, such as an
#' internet service provider (ISP), that clients access the resources
#' through. Setting this limit can help control billing costs.
#' 
#' To learn more, see [Choosing a city-network maximum
#' value](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html)
#' in the Amazon CloudWatch Internet Monitor section of the *CloudWatch
#' User Guide*.
#' @param InternetMeasurementsLogDelivery Publish internet measurements for Internet Monitor to an Amazon S3
#' bucket in addition to CloudWatch Logs.
#' @param TrafficPercentageToMonitor The percentage of the internet-facing traffic for your application that
#' you want to monitor with this monitor. If you set a city-networks
#' maximum, that limit overrides the traffic percentage that you set.
#' 
#' To learn more, see [Choosing an application traffic percentage to
#' monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html)
#' in the Amazon CloudWatch Internet Monitor section of the *CloudWatch
#' User Guide*.
#' @param HealthEventsConfig Defines the threshold percentages and other configuration information
#' for when Amazon CloudWatch Internet Monitor creates a health event.
#' Internet Monitor creates a health event when an internet issue that
#' affects your application end users has a health score percentage that is
#' at or below a specific threshold, and, sometimes, when other criteria
#' are met.
#' 
#' If you don't set a health event threshold, the default value is 95%.
#' 
#' For more information, see [Change health event
#' thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview)
#' in the Internet Monitor section of the *CloudWatch User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_create_monitor
cloudwatchinternetmonitor_create_monitor <- function(MonitorName, Resources = NULL, ClientToken = NULL, Tags = NULL, MaxCityNetworksToMonitor = NULL, InternetMeasurementsLogDelivery = NULL, TrafficPercentageToMonitor = NULL, HealthEventsConfig = NULL) {
  op <- new_operation(
    name = "CreateMonitor",
    http_method = "POST",
    http_path = "/v20210603/Monitors",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$create_monitor_input(MonitorName = MonitorName, Resources = Resources, ClientToken = ClientToken, Tags = Tags, MaxCityNetworksToMonitor = MaxCityNetworksToMonitor, InternetMeasurementsLogDelivery = InternetMeasurementsLogDelivery, TrafficPercentageToMonitor = TrafficPercentageToMonitor, HealthEventsConfig = HealthEventsConfig)
  output <- .cloudwatchinternetmonitor$create_monitor_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$create_monitor <- cloudwatchinternetmonitor_create_monitor

#' Deletes a monitor in Amazon CloudWatch Internet Monitor
#'
#' @description
#' Deletes a monitor in Amazon CloudWatch Internet Monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_delete_monitor/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_delete_monitor/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor to delete.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_delete_monitor
cloudwatchinternetmonitor_delete_monitor <- function(MonitorName) {
  op <- new_operation(
    name = "DeleteMonitor",
    http_method = "DELETE",
    http_path = "/v20210603/Monitors/{MonitorName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$delete_monitor_input(MonitorName = MonitorName)
  output <- .cloudwatchinternetmonitor$delete_monitor_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$delete_monitor <- cloudwatchinternetmonitor_delete_monitor

#' Gets information that Amazon CloudWatch Internet Monitor has created and
#' stored about a health event for a specified monitor
#'
#' @description
#' Gets information that Amazon CloudWatch Internet Monitor has created and stored about a health event for a specified monitor. This information includes the impacted locations, and all the information related to the event, by location.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_health_event/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_health_event/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param EventId &#91;required&#93; The internally-generated identifier of a health event. Because `EventID`
#' contains the forward slash (“/”) character, you must URL-encode the
#' `EventID` field in the request URL.
#' @param LinkedAccountId The account ID for an account that you've set up cross-account sharing
#' for in Amazon CloudWatch Internet Monitor. You configure cross-account
#' sharing by using Amazon CloudWatch Observability Access Manager. For
#' more information, see [Internet Monitor cross-account
#' observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_get_health_event
cloudwatchinternetmonitor_get_health_event <- function(MonitorName, EventId, LinkedAccountId = NULL) {
  op <- new_operation(
    name = "GetHealthEvent",
    http_method = "GET",
    http_path = "/v20210603/Monitors/{MonitorName}/HealthEvents/{EventId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$get_health_event_input(MonitorName = MonitorName, EventId = EventId, LinkedAccountId = LinkedAccountId)
  output <- .cloudwatchinternetmonitor$get_health_event_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$get_health_event <- cloudwatchinternetmonitor_get_health_event

#' Gets information that Amazon CloudWatch Internet Monitor has generated
#' about an internet event
#'
#' @description
#' Gets information that Amazon CloudWatch Internet Monitor has generated about an internet event. Internet Monitor displays information about recent global health events, called internet events, on a global outages map that is available to all Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_internet_event/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_internet_event/) for full documentation.
#'
#' @param EventId &#91;required&#93; The `EventId` of the internet event to return information for.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_get_internet_event
cloudwatchinternetmonitor_get_internet_event <- function(EventId) {
  op <- new_operation(
    name = "GetInternetEvent",
    http_method = "GET",
    http_path = "/v20210603/InternetEvents/{EventId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$get_internet_event_input(EventId = EventId)
  output <- .cloudwatchinternetmonitor$get_internet_event_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$get_internet_event <- cloudwatchinternetmonitor_get_internet_event

#' Gets information about a monitor in Amazon CloudWatch Internet Monitor
#' based on a monitor name
#'
#' @description
#' Gets information about a monitor in Amazon CloudWatch Internet Monitor based on a monitor name. The information returned includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and status information.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_monitor/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_monitor/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param LinkedAccountId The account ID for an account that you've set up cross-account sharing
#' for in Amazon CloudWatch Internet Monitor. You configure cross-account
#' sharing by using Amazon CloudWatch Observability Access Manager. For
#' more information, see [Internet Monitor cross-account
#' observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_get_monitor
cloudwatchinternetmonitor_get_monitor <- function(MonitorName, LinkedAccountId = NULL) {
  op <- new_operation(
    name = "GetMonitor",
    http_method = "GET",
    http_path = "/v20210603/Monitors/{MonitorName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$get_monitor_input(MonitorName = MonitorName, LinkedAccountId = LinkedAccountId)
  output <- .cloudwatchinternetmonitor$get_monitor_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$get_monitor <- cloudwatchinternetmonitor_get_monitor

#' Return the data for a query with the Amazon CloudWatch Internet Monitor
#' query interface
#'
#' @description
#' Return the data for a query with the Amazon CloudWatch Internet Monitor query interface. Specify the query that you want to return results for by providing a `QueryId` and a monitor name.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_query_results/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_query_results/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor to return data for.
#' @param QueryId &#91;required&#93; The ID of the query that you want to return data results for. A
#' `QueryId` is an internally-generated identifier for a specific query.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#' @param MaxResults The number of query results that you want to return with this call.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_get_query_results
cloudwatchinternetmonitor_get_query_results <- function(MonitorName, QueryId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "GET",
    http_path = "/v20210603/Monitors/{MonitorName}/Queries/{QueryId}/Results",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$get_query_results_input(MonitorName = MonitorName, QueryId = QueryId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .cloudwatchinternetmonitor$get_query_results_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$get_query_results <- cloudwatchinternetmonitor_get_query_results

#' Returns the current status of a query for the Amazon CloudWatch Internet
#' Monitor query interface, for a specified query ID and monitor
#'
#' @description
#' Returns the current status of a query for the Amazon CloudWatch Internet Monitor query interface, for a specified query ID and monitor. When you run a query, check the status to make sure that the query has `SUCCEEDED` before you review the results.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_query_status/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_get_query_status/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param QueryId &#91;required&#93; The ID of the query that you want to return the status for. A `QueryId`
#' is an internally-generated dentifier for a specific query.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_get_query_status
cloudwatchinternetmonitor_get_query_status <- function(MonitorName, QueryId) {
  op <- new_operation(
    name = "GetQueryStatus",
    http_method = "GET",
    http_path = "/v20210603/Monitors/{MonitorName}/Queries/{QueryId}/Status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$get_query_status_input(MonitorName = MonitorName, QueryId = QueryId)
  output <- .cloudwatchinternetmonitor$get_query_status_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$get_query_status <- cloudwatchinternetmonitor_get_query_status

#' Lists all health events for a monitor in Amazon CloudWatch Internet
#' Monitor
#'
#' @description
#' Lists all health events for a monitor in Amazon CloudWatch Internet Monitor. Returns information for health events including the event start and end times, and the status.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_health_events/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_health_events/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param StartTime The time when a health event started.
#' @param EndTime The time when a health event ended. If the health event is still
#' ongoing, then the end time is not set.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#' @param MaxResults The number of health event objects that you want to return with this
#' call.
#' @param EventStatus The status of a health event.
#' @param LinkedAccountId The account ID for an account that you've set up cross-account sharing
#' for in Amazon CloudWatch Internet Monitor. You configure cross-account
#' sharing by using Amazon CloudWatch Observability Access Manager. For
#' more information, see [Internet Monitor cross-account
#' observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_list_health_events
cloudwatchinternetmonitor_list_health_events <- function(MonitorName, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL, EventStatus = NULL, LinkedAccountId = NULL) {
  op <- new_operation(
    name = "ListHealthEvents",
    http_method = "GET",
    http_path = "/v20210603/Monitors/{MonitorName}/HealthEvents",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "HealthEvents"),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$list_health_events_input(MonitorName = MonitorName, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults, EventStatus = EventStatus, LinkedAccountId = LinkedAccountId)
  output <- .cloudwatchinternetmonitor$list_health_events_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$list_health_events <- cloudwatchinternetmonitor_list_health_events

#' Lists internet events that cause performance or availability issues for
#' client locations
#'
#' @description
#' Lists internet events that cause performance or availability issues for client locations. Amazon CloudWatch Internet Monitor displays information about recent global health events, called internet events, on a global outages map that is available to all Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_internet_events/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_internet_events/) for full documentation.
#'
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#' @param MaxResults The number of query results that you want to return with this call.
#' @param StartTime The start time of the time window that you want to get a list of
#' internet events for.
#' @param EndTime The end time of the time window that you want to get a list of internet
#' events for.
#' @param EventStatus The status of an internet event.
#' @param EventType The type of network impairment.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_list_internet_events
cloudwatchinternetmonitor_list_internet_events <- function(NextToken = NULL, MaxResults = NULL, StartTime = NULL, EndTime = NULL, EventStatus = NULL, EventType = NULL) {
  op <- new_operation(
    name = "ListInternetEvents",
    http_method = "GET",
    http_path = "/v20210603/InternetEvents",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "InternetEvents"),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$list_internet_events_input(NextToken = NextToken, MaxResults = MaxResults, StartTime = StartTime, EndTime = EndTime, EventStatus = EventStatus, EventType = EventType)
  output <- .cloudwatchinternetmonitor$list_internet_events_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$list_internet_events <- cloudwatchinternetmonitor_list_internet_events

#' Lists all of your monitors for Amazon CloudWatch Internet Monitor and
#' their statuses, along with the Amazon Resource Name (ARN) and name of
#' each monitor
#'
#' @description
#' Lists all of your monitors for Amazon CloudWatch Internet Monitor and their statuses, along with the Amazon Resource Name (ARN) and name of each monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_monitors/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_monitors/) for full documentation.
#'
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#' @param MaxResults The number of monitor objects that you want to return with this call.
#' @param MonitorStatus The status of a monitor. This includes the status of the data processing
#' for the monitor and the status of the monitor itself.
#' 
#' For information about the statuses for a monitor, see
#' [Monitor](https://docs.aws.amazon.com/internet-monitor/latest/api/API_Monitor.html).
#' @param IncludeLinkedAccounts A boolean option that you can set to `TRUE` to include monitors for
#' linked accounts in a list of monitors, when you've set up cross-account
#' sharing in Amazon CloudWatch Internet Monitor. You configure
#' cross-account sharing by using Amazon CloudWatch Observability Access
#' Manager. For more information, see [Internet Monitor cross-account
#' observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_list_monitors
cloudwatchinternetmonitor_list_monitors <- function(NextToken = NULL, MaxResults = NULL, MonitorStatus = NULL, IncludeLinkedAccounts = NULL) {
  op <- new_operation(
    name = "ListMonitors",
    http_method = "GET",
    http_path = "/v20210603/Monitors",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Monitors"),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$list_monitors_input(NextToken = NextToken, MaxResults = MaxResults, MonitorStatus = MonitorStatus, IncludeLinkedAccounts = IncludeLinkedAccounts)
  output <- .cloudwatchinternetmonitor$list_monitors_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$list_monitors <- cloudwatchinternetmonitor_list_monitors

#' Lists the tags for a resource
#'
#' @description
#' Lists the tags for a resource. Tags are supported only for monitors in Amazon CloudWatch Internet Monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_list_tags_for_resource
cloudwatchinternetmonitor_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cloudwatchinternetmonitor$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$list_tags_for_resource <- cloudwatchinternetmonitor_list_tags_for_resource

#' Start a query to return data for a specific query type for the Amazon
#' CloudWatch Internet Monitor query interface
#'
#' @description
#' Start a query to return data for a specific query type for the Amazon CloudWatch Internet Monitor query interface. Specify a time period for the data that you want returned by using `StartTime` and `EndTime`. You filter the query results to return by providing parameters that you specify with `FilterParameters`.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_start_query/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_start_query/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor to query.
#' @param StartTime &#91;required&#93; The timestamp that is the beginning of the period that you want to
#' retrieve data for with your query.
#' @param EndTime &#91;required&#93; The timestamp that is the end of the period that you want to retrieve
#' data for with your query.
#' @param QueryType &#91;required&#93; The type of query to run. The following are the three types of queries
#' that you can run using the Internet Monitor query interface:
#' 
#' -   `MEASUREMENTS`: Provides availability score, performance score,
#'     total traffic, and round-trip times, at 5 minute intervals.
#' 
#' -   `TOP_LOCATIONS`: Provides availability score, performance score,
#'     total traffic, and time to first byte (TTFB) information, for the
#'     top location and ASN combinations that you're monitoring, by traffic
#'     volume.
#' 
#' -   `TOP_LOCATION_DETAILS`: Provides TTFB for Amazon CloudFront, your
#'     current configuration, and the best performing EC2 configuration, at
#'     1 hour intervals.
#' 
#' -   `OVERALL_TRAFFIC_SUGGESTIONS`: Provides TTFB, using a 30-day
#'     weighted average, for all traffic in each Amazon Web Services
#'     location that is monitored.
#' 
#' -   `OVERALL_TRAFFIC_SUGGESTIONS_DETAILS`: Provides TTFB, using a 30-day
#'     weighted average, for each top location, for a proposed Amazon Web
#'     Services location. Must provide an Amazon Web Services location to
#'     search.
#' 
#' -   `ROUTING_SUGGESTIONS`: Provides the predicted average round-trip
#'     time (RTT) from an IP prefix toward an Amazon Web Services location
#'     for a DNS resolver. The RTT is calculated at one hour intervals,
#'     over a one hour period.
#' 
#' For lists of the fields returned with each query type and more
#' information about how each type of query is performed, see [Using the
#' Amazon CloudWatch Internet Monitor query
#' interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#' @param FilterParameters The `FilterParameters` field that you use with Amazon CloudWatch
#' Internet Monitor queries is a string the defines how you want a query to
#' be filtered. The filter parameters that you can specify depend on the
#' query type, since each query type returns a different set of Internet
#' Monitor data.
#' 
#' For more information about specifying filter parameters, see [Using the
#' Amazon CloudWatch Internet Monitor query
#' interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#' @param LinkedAccountId The account ID for an account that you've set up cross-account sharing
#' for in Amazon CloudWatch Internet Monitor. You configure cross-account
#' sharing by using Amazon CloudWatch Observability Access Manager. For
#' more information, see [Internet Monitor cross-account
#' observability](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html)
#' in the Amazon CloudWatch Internet Monitor User Guide.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_start_query
cloudwatchinternetmonitor_start_query <- function(MonitorName, StartTime, EndTime, QueryType, FilterParameters = NULL, LinkedAccountId = NULL) {
  op <- new_operation(
    name = "StartQuery",
    http_method = "POST",
    http_path = "/v20210603/Monitors/{MonitorName}/Queries",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$start_query_input(MonitorName = MonitorName, StartTime = StartTime, EndTime = EndTime, QueryType = QueryType, FilterParameters = FilterParameters, LinkedAccountId = LinkedAccountId)
  output <- .cloudwatchinternetmonitor$start_query_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$start_query <- cloudwatchinternetmonitor_start_query

#' Stop a query that is progress for a specific monitor
#'
#' @description
#' Stop a query that is progress for a specific monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_stop_query/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_stop_query/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param QueryId &#91;required&#93; The ID of the query that you want to stop. A `QueryId` is an
#' internally-generated identifier for a specific query.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_stop_query
cloudwatchinternetmonitor_stop_query <- function(MonitorName, QueryId) {
  op <- new_operation(
    name = "StopQuery",
    http_method = "DELETE",
    http_path = "/v20210603/Monitors/{MonitorName}/Queries/{QueryId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$stop_query_input(MonitorName = MonitorName, QueryId = QueryId)
  output <- .cloudwatchinternetmonitor$stop_query_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$stop_query <- cloudwatchinternetmonitor_stop_query

#' Adds a tag to a resource
#'
#' @description
#' Adds a tag to a resource. Tags are supported only for monitors in Amazon CloudWatch Internet Monitor. You can add a maximum of 50 tags in Internet Monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_tag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a tag that you add to a resource.
#' Tags are supported only for monitors in Amazon CloudWatch Internet
#' Monitor.
#' @param Tags &#91;required&#93; Tags that you add to a resource. You can add a maximum of 50 tags in
#' Internet Monitor.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_tag_resource
cloudwatchinternetmonitor_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cloudwatchinternetmonitor$tag_resource_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$tag_resource <- cloudwatchinternetmonitor_tag_resource

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_untag_resource/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a tag you remove a resource from.
#' @param TagKeys &#91;required&#93; Tag keys that you remove from a resource.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_untag_resource
cloudwatchinternetmonitor_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cloudwatchinternetmonitor$untag_resource_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$untag_resource <- cloudwatchinternetmonitor_untag_resource

#' Updates a monitor
#'
#' @description
#' Updates a monitor. You can update a monitor to change the percentage of traffic to monitor or the maximum number of city-networks (locations and ASNs), to add or remove resources, or to change the status of the monitor. Note that you can't change the name of a monitor.
#'
#' See [https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_update_monitor/](https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_update_monitor/) for full documentation.
#'
#' @param MonitorName &#91;required&#93; The name of the monitor.
#' @param ResourcesToAdd The resources to include in a monitor, which you provide as a set of
#' Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon
#' CloudFront distributions, or Amazon WorkSpaces directories.
#' 
#' You can add a combination of VPCs and CloudFront distributions, or you
#' can add WorkSpaces directories, or you can add NLBs. You can't add NLBs
#' or WorkSpaces directories together with any other resources.
#' 
#' If you add only Amazon Virtual Private Clouds resources, at least one
#' VPC must have an Internet Gateway attached to it, to make sure that it
#' has internet connectivity.
#' @param ResourcesToRemove The resources to remove from a monitor, which you provide as a set of
#' Amazon Resource Names (ARNs).
#' @param Status The status for a monitor. The accepted values for `Status` with the
#' [`update_monitor`][cloudwatchinternetmonitor_update_monitor] API call
#' are the following: `ACTIVE` and `INACTIVE`. The following values are
#' *not* accepted: `PENDING`, and `ERROR`.
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters that you
#' specify to make an idempotent API request. You should not reuse the same
#' client token for other API requests.
#' @param MaxCityNetworksToMonitor The maximum number of city-networks to monitor for your application. A
#' city-network is the location (city) where clients access your
#' application resources from and the ASN or network provider, such as an
#' internet service provider (ISP), that clients access the resources
#' through. Setting this limit can help control billing costs.
#' @param InternetMeasurementsLogDelivery Publish internet measurements for Internet Monitor to another location,
#' such as an Amazon S3 bucket. The measurements are also published to
#' Amazon CloudWatch Logs.
#' @param TrafficPercentageToMonitor The percentage of the internet-facing traffic for your application that
#' you want to monitor with this monitor. If you set a city-networks
#' maximum, that limit overrides the traffic percentage that you set.
#' 
#' To learn more, see [Choosing an application traffic percentage to
#' monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html)
#' in the Amazon CloudWatch Internet Monitor section of the *CloudWatch
#' User Guide*.
#' @param HealthEventsConfig The list of health score thresholds. A threshold percentage for health
#' scores, along with other configuration information, determines when
#' Internet Monitor creates a health event when there's an internet issue
#' that affects your application end users.
#' 
#' For more information, see [Change health event
#' thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview)
#' in the Internet Monitor section of the *CloudWatch User Guide*.
#'
#' @keywords internal
#'
#' @rdname cloudwatchinternetmonitor_update_monitor
cloudwatchinternetmonitor_update_monitor <- function(MonitorName, ResourcesToAdd = NULL, ResourcesToRemove = NULL, Status = NULL, ClientToken = NULL, MaxCityNetworksToMonitor = NULL, InternetMeasurementsLogDelivery = NULL, TrafficPercentageToMonitor = NULL, HealthEventsConfig = NULL) {
  op <- new_operation(
    name = "UpdateMonitor",
    http_method = "PATCH",
    http_path = "/v20210603/Monitors/{MonitorName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cloudwatchinternetmonitor$update_monitor_input(MonitorName = MonitorName, ResourcesToAdd = ResourcesToAdd, ResourcesToRemove = ResourcesToRemove, Status = Status, ClientToken = ClientToken, MaxCityNetworksToMonitor = MaxCityNetworksToMonitor, InternetMeasurementsLogDelivery = InternetMeasurementsLogDelivery, TrafficPercentageToMonitor = TrafficPercentageToMonitor, HealthEventsConfig = HealthEventsConfig)
  output <- .cloudwatchinternetmonitor$update_monitor_output()
  config <- get_config()
  svc <- .cloudwatchinternetmonitor$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudwatchinternetmonitor$operations$update_monitor <- cloudwatchinternetmonitor_update_monitor
