# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include health_service.R
NULL

#' Returns a list of accounts in the organization from Organizations that
#' are affected by the provided event
#'
#' @description
#' Returns a list of accounts in the organization from Organizations that are affected by the provided event. For more information about the different types of Health events, see [Event](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html).
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_affected_accounts_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_affected_accounts_for_organization/) for full documentation.
#'
#' @param eventArn &#91;required&#93; The unique identifier for the event. The event ARN has the
#' `arn:aws:health:event-region::event/SERVICE/EVENT_TYPE_CODE/EVENT_TYPE_PLUS_ID `
#' format.
#' 
#' For example, an event ARN might look like the following:
#' 
#' `arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456`
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_accounts_for_organization
health_describe_affected_accounts_for_organization <- function(eventArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedAccountsForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "affectedAccounts", non_aggregate_keys = list( "eventScopeCode")),
    stream_api = FALSE
  )
  input <- .health$describe_affected_accounts_for_organization_input(eventArn = eventArn, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_accounts_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_accounts_for_organization <- health_describe_affected_accounts_for_organization

#' Returns a list of entities that have been affected by the specified
#' events, based on the specified filter criteria
#'
#' @description
#' Returns a list of entities that have been affected by the specified events, based on the specified filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service. Events that have impact beyond that of the affected entities, or where the extent of impact is unknown, include at least one entity indicating this.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_affected_entities/](https://www.paws-r-sdk.com/docs/health_describe_affected_entities/) for full documentation.
#'
#' @param filter &#91;required&#93; Values to narrow the results returned. At least one event ARN is
#' required.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_entities
health_describe_affected_entities <- function(filter, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeAffectedEntities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "entities"),
    stream_api = FALSE
  )
  input <- .health$describe_affected_entities_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_affected_entities_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_entities <- health_describe_affected_entities

#' Returns a list of entities that have been affected by one or more events
#' for one or more accounts in your organization in Organizations, based on
#' the filter criteria
#'
#' @description
#' Returns a list of entities that have been affected by one or more events for one or more accounts in your organization in Organizations, based on the filter criteria. Entities can refer to individual customer resources, groups of customer resources, or any other construct, depending on the Amazon Web Services service.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_affected_entities_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_affected_entities_for_organization/) for full documentation.
#'
#' @param organizationEntityFilters A JSON set of elements including the `awsAccountId` and the `eventArn`.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param organizationEntityAccountFilters A JSON set of elements including the `awsAccountId`, `eventArn` and a
#' set of `statusCodes`.
#'
#' @keywords internal
#'
#' @rdname health_describe_affected_entities_for_organization
health_describe_affected_entities_for_organization <- function(organizationEntityFilters = NULL, locale = NULL, nextToken = NULL, maxResults = NULL, organizationEntityAccountFilters = NULL) {
  op <- new_operation(
    name = "DescribeAffectedEntitiesForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", non_aggregate_keys = list( "failedSet"), output_token = "nextToken", result_key = "entities"),
    stream_api = FALSE
  )
  input <- .health$describe_affected_entities_for_organization_input(organizationEntityFilters = organizationEntityFilters, locale = locale, nextToken = nextToken, maxResults = maxResults, organizationEntityAccountFilters = organizationEntityAccountFilters)
  output <- .health$describe_affected_entities_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_affected_entities_for_organization <- health_describe_affected_entities_for_organization

#' Returns the number of entities that are affected by each of the
#' specified events
#'
#' @description
#' Returns the number of entities that are affected by each of the specified events.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_entity_aggregates/](https://www.paws-r-sdk.com/docs/health_describe_entity_aggregates/) for full documentation.
#'
#' @param eventArns A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#'
#' @keywords internal
#'
#' @rdname health_describe_entity_aggregates
health_describe_entity_aggregates <- function(eventArns = NULL) {
  op <- new_operation(
    name = "DescribeEntityAggregates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$describe_entity_aggregates_input(eventArns = eventArns)
  output <- .health$describe_entity_aggregates_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_entity_aggregates <- health_describe_entity_aggregates

#' Returns a list of entity aggregates for your Organizations that are
#' affected by each of the specified events
#'
#' @description
#' Returns a list of entity aggregates for your Organizations that are affected by each of the specified events.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_entity_aggregates_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_entity_aggregates_for_organization/) for full documentation.
#'
#' @param eventArns &#91;required&#93; A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#' @param awsAccountIds A list of 12-digit Amazon Web Services account numbers that contains the
#' affected entities.
#'
#' @keywords internal
#'
#' @rdname health_describe_entity_aggregates_for_organization
health_describe_entity_aggregates_for_organization <- function(eventArns, awsAccountIds = NULL) {
  op <- new_operation(
    name = "DescribeEntityAggregatesForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$describe_entity_aggregates_for_organization_input(eventArns = eventArns, awsAccountIds = awsAccountIds)
  output <- .health$describe_entity_aggregates_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_entity_aggregates_for_organization <- health_describe_entity_aggregates_for_organization

#' Returns the number of events of each event type (issue, scheduled
#' change, and account notification)
#'
#' @description
#' Returns the number of events of each event type (issue, scheduled change, and account notification). If no filter is specified, the counts of all events in each category are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_event_aggregates/](https://www.paws-r-sdk.com/docs/health_describe_event_aggregates/) for full documentation.
#'
#' @param filter Values to narrow the results returned.
#' @param aggregateField &#91;required&#93; The only currently supported value is `eventTypeCategory`.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#'
#' @keywords internal
#'
#' @rdname health_describe_event_aggregates
health_describe_event_aggregates <- function(filter = NULL, aggregateField, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeEventAggregates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "eventAggregates"),
    stream_api = FALSE
  )
  input <- .health$describe_event_aggregates_input(filter = filter, aggregateField = aggregateField, maxResults = maxResults, nextToken = nextToken)
  output <- .health$describe_event_aggregates_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_aggregates <- health_describe_event_aggregates

#' Returns detailed information about one or more specified events
#'
#' @description
#' Returns detailed information about one or more specified events. Information includes standard event data (Amazon Web Services Region, service, and so on, as returned by [`describe_events`][health_describe_events]), a detailed event description, and possible additional metadata that depends upon the nature of the event. Affected entities are not included. To retrieve the entities, use the [`describe_affected_entities`][health_describe_affected_entities] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_event_details/](https://www.paws-r-sdk.com/docs/health_describe_event_details/) for full documentation.
#'
#' @param eventArns &#91;required&#93; A list of event ARNs (unique identifiers). For example:
#' `"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"`
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @keywords internal
#'
#' @rdname health_describe_event_details
health_describe_event_details <- function(eventArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$describe_event_details_input(eventArns = eventArns, locale = locale)
  output <- .health$describe_event_details_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_details <- health_describe_event_details

#' Returns detailed information about one or more specified events for one
#' or more Amazon Web Services accounts in your organization
#'
#' @description
#' Returns detailed information about one or more specified events for one or more Amazon Web Services accounts in your organization. This information includes standard event data (such as the Amazon Web Services Region and service), an event description, and (depending on the event) possible metadata. This operation doesn't return affected entities, such as the resources related to the event. To return affected entities, use the [`describe_affected_entities_for_organization`][health_describe_affected_entities_for_organization] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_event_details_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_event_details_for_organization/) for full documentation.
#'
#' @param organizationEventDetailFilters &#91;required&#93; A set of JSON elements that includes the `awsAccountId` and the
#' `eventArn`.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @keywords internal
#'
#' @rdname health_describe_event_details_for_organization
health_describe_event_details_for_organization <- function(organizationEventDetailFilters, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventDetailsForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$describe_event_details_for_organization_input(organizationEventDetailFilters = organizationEventDetailFilters, locale = locale)
  output <- .health$describe_event_details_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_details_for_organization <- health_describe_event_details_for_organization

#' Returns the event types that meet the specified filter criteria
#'
#' @description
#' Returns the event types that meet the specified filter criteria. You can use this API operation to find information about the Health event, such as the category, Amazon Web Services service, and event code. The metadata for each event appears in the [EventType](https://docs.aws.amazon.com/health/latest/APIReference/API_EventType.html) object.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_event_types/](https://www.paws-r-sdk.com/docs/health_describe_event_types/) for full documentation.
#'
#' @param filter Values to narrow the results returned.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' 
#' If you don't specify the `maxResults` parameter, this operation returns
#' a maximum of 30 items by default.
#'
#' @keywords internal
#'
#' @rdname health_describe_event_types
health_describe_event_types <- function(filter = NULL, locale = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeEventTypes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "eventTypes"),
    stream_api = FALSE
  )
  input <- .health$describe_event_types_input(filter = filter, locale = locale, nextToken = nextToken, maxResults = maxResults)
  output <- .health$describe_event_types_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_event_types <- health_describe_event_types

#' Returns information about events that meet the specified filter criteria
#'
#' @description
#' Returns information about events that meet the specified filter criteria. Events are returned in a summary form and do not include the detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the [`describe_event_details`][health_describe_event_details] and [`describe_affected_entities`][health_describe_affected_entities] operations.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_events/](https://www.paws-r-sdk.com/docs/health_describe_events/) for full documentation.
#'
#' @param filter Values to narrow the results returned.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @keywords internal
#'
#' @rdname health_describe_events
health_describe_events <- function(filter = NULL, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "events"),
    stream_api = FALSE
  )
  input <- .health$describe_events_input(filter = filter, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .health$describe_events_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_events <- health_describe_events

#' Returns information about events across your organization in
#' Organizations
#'
#' @description
#' Returns information about events across your organization in Organizations. You can use the`filters` parameter to specify the events that you want to return. Events are returned in a summary form and don't include the affected accounts, detailed description, any additional metadata that depends on the event type, or any affected resources. To retrieve that information, use the following operations:
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_events_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_events_for_organization/) for full documentation.
#'
#' @param filter Values to narrow the results returned.
#' @param nextToken If the results of a search are large, only a portion of the results are
#' returned, and a `nextToken` pagination token is returned in the
#' response. To retrieve the next batch of results, reissue the search
#' request and include the returned token. When all results have been
#' returned, the response does not contain a pagination token value.
#' @param maxResults The maximum number of items to return in one batch, between 10 and 100,
#' inclusive.
#' @param locale The locale (language) to return information in. English (en) is the
#' default and the only supported value at this time.
#'
#' @keywords internal
#'
#' @rdname health_describe_events_for_organization
health_describe_events_for_organization <- function(filter = NULL, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "DescribeEventsForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "nextToken", limit_key = "maxResults", output_token = "nextToken", result_key = "events"),
    stream_api = FALSE
  )
  input <- .health$describe_events_for_organization_input(filter = filter, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .health$describe_events_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_events_for_organization <- health_describe_events_for_organization

#' This operation provides status information on enabling or disabling
#' Health to work with your organization
#'
#' @description
#' This operation provides status information on enabling or disabling Health to work with your organization. To call this operation, you must use the organization's management account.
#'
#' See [https://www.paws-r-sdk.com/docs/health_describe_health_service_status_for_organization/](https://www.paws-r-sdk.com/docs/health_describe_health_service_status_for_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname health_describe_health_service_status_for_organization
health_describe_health_service_status_for_organization <- function() {
  op <- new_operation(
    name = "DescribeHealthServiceStatusForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$describe_health_service_status_for_organization_input()
  output <- .health$describe_health_service_status_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$describe_health_service_status_for_organization <- health_describe_health_service_status_for_organization

#' Disables Health from working with Organizations
#'
#' @description
#' Disables Health from working with Organizations. To call this operation, you must sign in to the organization's management account. For more information, see [Aggregating Health events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html) in the *Health User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/health_disable_health_service_access_for_organization/](https://www.paws-r-sdk.com/docs/health_disable_health_service_access_for_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname health_disable_health_service_access_for_organization
health_disable_health_service_access_for_organization <- function() {
  op <- new_operation(
    name = "DisableHealthServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$disable_health_service_access_for_organization_input()
  output <- .health$disable_health_service_access_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$disable_health_service_access_for_organization <- health_disable_health_service_access_for_organization

#' Enables Health to work with Organizations
#'
#' @description
#' Enables Health to work with Organizations. You can use the organizational view feature to aggregate events from all Amazon Web Services accounts in your organization in a centralized location.
#'
#' See [https://www.paws-r-sdk.com/docs/health_enable_health_service_access_for_organization/](https://www.paws-r-sdk.com/docs/health_enable_health_service_access_for_organization/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname health_enable_health_service_access_for_organization
health_enable_health_service_access_for_organization <- function() {
  op <- new_operation(
    name = "EnableHealthServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .health$enable_health_service_access_for_organization_input()
  output <- .health$enable_health_service_access_for_organization_output()
  config <- get_config()
  svc <- .health$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.health$operations$enable_health_service_access_for_organization <- health_enable_health_service_access_for_organization
