% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_continue_update_rollback}
\alias{cloudformation_continue_update_rollback}
\title{For a specified stack that's in the UPDATE_ROLLBACK_FAILED state,
continues rolling it back to the UPDATE_ROLLBACK_COMPLETE state}
\usage{
cloudformation_continue_update_rollback(
  StackName,
  RoleARN = NULL,
  ResourcesToSkip = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{StackName}{[required] The name or the unique ID of the stack that you want to continue rolling
back.

Don't specify the name of a nested stack (a stack that was created by
using the \verb{AWS::CloudFormation::Stack} resource). Instead, use this
operation on the parent stack (the stack that contains the
\verb{AWS::CloudFormation::Stack} resource).}

\item{RoleARN}{The Amazon Resource Name (ARN) of an IAM role that CloudFormation
assumes to roll back the stack. CloudFormation uses the role's
credentials to make calls on your behalf. CloudFormation always uses
this role for all future operations on the stack. Provided that users
have permission to operate on the stack, CloudFormation uses this role
even if the users don't have permission to pass it. Ensure that the role
grants least permission.

If you don't specify a value, CloudFormation uses the role that was
previously associated with the stack. If no role is available,
CloudFormation uses a temporary session that's generated from your user
credentials.}

\item{ResourcesToSkip}{A list of the logical IDs of the resources that CloudFormation skips
during the continue update rollback operation. You can specify only
resources that are in the \code{UPDATE_FAILED} state because a rollback
failed. You can't specify resources that are in the \code{UPDATE_FAILED}
state for other reasons, for example, because an update was canceled. To
check why a resource update failed, use the
\code{\link[=cloudformation_describe_stack_resources]{describe_stack_resources}}
action, and view the resource status reason.

Specify this property to skip rolling back resources that CloudFormation
can't successfully roll back. We recommend that you
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed}{troubleshoot}
resources before skipping them. CloudFormation sets the status of the
specified resources to \code{UPDATE_COMPLETE} and continues to roll back the
stack. After the rollback is complete, the state of the skipped
resources will be inconsistent with the state of the resources in the
stack template. Before performing another stack update, you must update
the stack or resources to be consistent with each other. If you don't,
subsequent stack updates might fail, and the stack will become
unrecoverable.

Specify the minimum number of resources required to successfully roll
back your stack. For example, a failed resource update might cause
dependent resources to fail. In this case, it might not be necessary to
skip the dependent resources.

To skip resources that are part of nested stacks, use the following
format: \code{NestedStackName.ResourceLogicalID}. If you want to specify the
logical ID of a stack resource (\verb{Type: AWS::CloudFormation::Stack}) in
the \code{ResourcesToSkip} list, then its corresponding embedded stack must
be in one of the following states: \code{DELETE_IN_PROGRESS},
\code{DELETE_COMPLETE}, or \code{DELETE_FAILED}.

Don't confuse a child stack's name with its corresponding logical ID
defined in the parent stack. For an example of a continue update
rollback operation with nested stacks, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html#nested-stacks}{Continue rolling back from failed nested stack updates}.}

\item{ClientRequestToken}{A unique identifier for this
\code{\link[=cloudformation_continue_update_rollback]{continue_update_rollback}}
request. Specify this token if you plan to retry requests so that
CloudFormation knows that you're not attempting to continue the rollback
to a stack with the same name. You might retry
\code{\link[=cloudformation_continue_update_rollback]{continue_update_rollback}}
requests to ensure that CloudFormation successfully received them.}
}
\description{
For a specified stack that's in the \code{UPDATE_ROLLBACK_FAILED} state, continues rolling it back to the \code{UPDATE_ROLLBACK_COMPLETE} state. Depending on the cause of the failure, you can manually \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/troubleshooting.html#troubleshooting-errors-update-rollback-failed}{fix the error} and continue the rollback. By continuing the rollback, you can return your stack to a working state (the \code{UPDATE_ROLLBACK_COMPLETE} state), and then try to update the stack again.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_continue_update_rollback/} for full documentation.
}
\keyword{internal}
